#' datapreparation des données
#'
#' @param reg code region
#' @param abc TRUE si on veut garder les zonages abc
#' @param zone_a_secretiser listes des zonages à secretiser
#' @param marches_a_secretiser liste des marchés à secretiser : individuel, collectif, tous
#'
#' @importFrom COGiter filtrer_cog
#' @importFrom dplyr filter mutate arrange bind_rows slice_max pull select
#' @importFrom forcats fct_relevel fct_drop fct_inorder
#' @importFrom lubridate years
#' @importFrom stringr str_split_fixed
#' @importFrom rlang .data
#' @return un dataframe filtré sur la région souhaitée
#' @export
data_prep <- function(reg, abc = TRUE, zone_a_secretiser = "", marches_a_secretiser = "") {
  if (abc == FALSE) {
    result <- indic_ecln %>%
      COGiter::filtrer_cog(reg = reg, garder_supra = ">") %>%
      dplyr::mutate(TypeZone = forcats::fct_relevel(.data$TypeZone, "France", "R\u00e9gions", "D\u00e9partements", "Epci")) %>%
      dplyr::arrange(.data$TypeZone, .data$Zone) %>%
      dplyr::mutate(
        Zone = forcats::fct_drop(.data$Zone),
        Zone = forcats::fct_inorder(.data$Zone),
        marche = stringr::str_split_fixed(.data$Indicateur, "-", n = 2)[, 2],
        Valeur = ifelse(.data$Zone %in% zone_a_secretiser &
          .data$marche %in% marches_a_secretiser,
        NA,
        .data$Valeur
        ),
        TauxEvolution12Mois = ifelse(.data$Zone %in% zone_a_secretiser &
          .data$marche %in% marches_a_secretiser,
        NA,
        .data$TauxEvolution12Mois
        )
      )
  }
  if (abc == TRUE) {
    result <- indic_ecln %>%
      COGiter::filtrer_cog(reg = reg, garder_supra = ">")

    abc <- indic_ecln %>%
      dplyr::filter(.data$TypeZone == "ABC")

    result <- dplyr::bind_rows(result, abc) %>%
      dplyr::mutate(TypeZone = forcats::fct_relevel(as.factor(.data$TypeZone), "France", "R\u00e9gions", "D\u00e9partements", "Epci", "ABC")) %>%
      dplyr::arrange(.data$TypeZone, .data$Zone) %>%
      dplyr::mutate(
        Zone = forcats::fct_drop(.data$Zone),
        Zone = forcats::fct_inorder(.data$Zone),
        marche = stringr::str_split_fixed(.data$Indicateur, "-", n = 2)[, 2],
        Valeur = ifelse(.data$Zone %in% zone_a_secretiser &
          .data$marche %in% marches_a_secretiser,
        NA,
        .data$Valeur
        ),
        TauxEvolution12Mois = ifelse(.data$Zone %in% zone_a_secretiser &
          .data$marche %in% marches_a_secretiser,
        NA,
        .data$TauxEvolution12Mois
        )
      )
  }

    liste_des_x_dernieres_periodes<- result %>%
      dplyr::mutate(Periode=as.numeric(.data$Periode)) %>%
      dplyr::select(.data$Periode) %>%
      unique() %>%
      dplyr::slice_max(.data$Periode,n = 20) %>%
      dplyr::pull() %>%
      as.Date(origin="1970-01-01")

    result <- result %>%
      dplyr::filter(.data$Periode %in% liste_des_x_dernieres_periodes)


  return(result)
}
