#' Création du tableau de synthèse trimestrielle
#'
#' @param data Le dataframe.
#' @param type_logement Collectifs ou individuels.
#'
#' @return un tableau kable
#' @export
#' @importFrom dplyr filter mutate select full_join arrange
#' @importFrom kableExtra kable_styling row_spec add_header_above footnote
#' @importFrom knitr kable
#' @importFrom stringr str_split_fixed
#' @importFrom tidyr spread
creer_tableau_synthese_trimestrielle <- function(data = indic_ecln,
                                                 type_logement = "logement") {
  indic <- c(
    "Encours - Logements",
    "Mises en vente - Logements",
    "Ventes - Logements",
    "PrixM2 - Logements"
  )
  if (type_logement == "individuel") {
    indic <- c(
      "Encours - Maisons",
      "Mises en vente - Maisons",
      "Ventes - Maisons",
      "PrixM2 - Maisons"
    )
  }
  if (type_logement == "collectif") {
    indic <- c(
      "Encours - Appartements",
      "Mises en vente - Appartements",
      "Ventes - Appartements",
      "PrixM2 - Appartements"
    )
  }

  indic_ecln %>%
    dplyr::filter(
      .data$Indicateur %in% indic,
      .data$TypeZone %in% c("France", "R\u00e9gions"),
      .data$TypeIndicateur != "Cumul annuel",
      .data$Periode == max(.data$Periode)
    ) %>%
    dplyr::mutate(Indicateur = str_split_fixed(.data$Indicateur, "-", 2)[, 1]) %>%
    dplyr::select(.data$TypeZone, .data$Zone, .data$Indicateur, .data$Valeur) %>%
    tidyr::spread(.data$Indicateur, .data$Valeur) %>%
    dplyr::full_join(
      indic_ecln %>%
        dplyr::filter(
          .data$Indicateur %in% indic,
          .data$TypeZone %in% c("France", "R\u00e9gions"),
          .data$TypeIndicateur != "Cumul annuel",
          .data$Periode == max(.data$Periode)
        ) %>%
        dplyr::mutate(Indicateur = stringr::str_split_fixed(.data$Indicateur, "-", 2)[, 1]) %>%
        dplyr::select(.data$TypeZone, .data$Zone, .data$Indicateur, .data$TauxEvolution12Mois) %>%
        spread(.data$Indicateur, .data$TauxEvolution12Mois),
      by = c("TypeZone", "Zone")
    ) %>%
    dplyr::arrange(.data$Zone) %>%
    dplyr::select(2, 6, 10, 4, 8, 3, 7, 5, 9)%>%
    knitr::kable("html",
      col.names = c(
        "Territoire", "Au cours du dernier trimestre", "\u00C9volution sur un an (en %)",
        "Au cours du dernier trimestre", "\u00C9volution sur un an (en %)",
        "\u00C0 la fin du dernier trimestre", "\u00C9volution sur un an (en %)",
        "Au cours du dernier trimestre", "\u00C9volution sur un an (en %)"
      ),
      digits = c(0, 0, 1, 0, 1, 0, 1, 0, 1),
      format.args = list(big.mark = " ", decimal.mark = ",")
    ) %>%
    kableExtra::kable_styling(font_size = 12) %>%
    kableExtra::row_spec(1:2, bold = T, background = "#f0f0f5") %>%
    kableExtra::add_header_above(c(" " = 1, "Ventes" = 2, "Mises en vente" = 2, "Encours" = 2, "Prix moyen du m\u00B2 (en \u20ac)" = 2)) %>%
    kableExtra::footnote(general_title="",general = "NC : donn\u00e9es non communiqu\u00e9es en raison du secret statistique (voir la section \u00C0 propos \u00E0 la fin du document)")

}
