#' Conversion d'une date au mois ou trimestre en format date au jour.
#'
#' @param Periode caractère une date en format anneetrimestre ou anneemois
#' @param Periodicite caractère Trim si la date est en trimestre, Mois pour une date au mois
#' @param sep le séparateur entre l'année et le mois/trimestre
#'
#' @return une date au format date
#' @importFrom dplyr case_when
#' @importFrom lubridate ymd days `%m+%`
#' @importFrom stringr str_split_fixed str_c str_replace
#' @export
#'
#' @examples
#' FormatDate("2010-10", Periodicite = "Mois")
#' @importFrom dplyr case_when
#' @importFrom lubridate ymd days
#' @importFrom stringr str_split_fixed str_c str_replace
FormatDate <- function(Periode, Periodicite, sep = "-") {
  Periode1 <- stringr::str_split_fixed(Periode, sep, 2)[, 1]
  Periode2 <- stringr::str_split_fixed(Periode, sep, 2)[, 2]

  if (Periodicite == "Trim") {
    return(
      lubridate::ymd(dplyr::case_when(
        Periode2 %in% c("Q1", "T1", "1") ~ stringr::str_c(Periode1, "0331"),
        Periode2 %in% c("Q2", "T2", "2") ~ stringr::str_c(Periode1, "0630"),
        Periode2 %in% c("Q3", "T3", "3") ~ stringr::str_c(Periode1, "0930"),
        Periode2 %in% c("Q4", "T4", "4") ~ stringr::str_c(Periode1, "1231")
      ))
    )
  }
  if (Periodicite == "Mois") {
    return(
      lubridate::ymd(stringr::str_c(stringr::str_replace(Periode, sep, ""), "01")) %m+% months(1) %m+% lubridate::days(-1)
    )
  }
}


#' conversion d'une variable date en nommage trimestriel
#'
#' @param Periode date à convertire
#'
#' @return une chaine de caractère
#' @importFrom dplyr case_when
#' @importFrom lubridate year month
#' @export
#'
#' @examples
#' FormatCaractere("2010-10-01")
FormatCaractere <- function(Periode) {
  trim <- dplyr::case_when(
    lubridate::month(Periode) <= 3 ~ "T1",
    lubridate::month(Periode) <= 6 ~ "T2",
    lubridate::month(Periode) <= 9 ~ "T3",
    lubridate::month(Periode) <= 12 ~ "T4"
  )
  return(
    paste0(lubridate::year(Periode), trim)
  )
}
