#' Table contenant les différents indicateurs de la source teruti utiles pour la publication.
#'
#' @encoding UTF-8
#' @format  Table de 2301 lignes et 6 colonnes:
#' \describe{
#'   \item{TypeZone}{Type de territoire}
#'   \item{CodeZone}{Code du territoire}
#'   \item{Zone}{Libellé du territoire}
#'   \item{date}{Millésime de la source}
#'   \item{variable}{Liste des indicateurs}
#'   \item{valeur}{Valeur de l'indicateur pour la modalité de variable}
#' }
#' @source \url{https://agreste.agriculture.gouv.fr/agreste-web/disaron/W0020/detail/}
"teruti"

#' Table contenant les différents indicateurs de la source observatoire_artificialisation utiles pour la publication.
#'
#' @encoding UTF-8
#' @format  Table de 399355 lignes et 9 colonnes:
#' \describe{
#'   \item{TypeZone}{Type de territoire}
#'   \item{CodeZone}{Code du territoire}
#'   \item{Zone}{Libellé du territoire}
#'   \item{date}{Millésime de la source}
#'   \item{flux_naf_artificialisation_activite}{flux naf artificialisation activite}
#'   \item{flux_naf_artificialisation_habitation}{flux naf artificialisation habitation}
#'   \item{flux_naf_artificialisation_inconnue}{flux naf artificialisation inconnue}
#'   \item{flux_naf_artificialisation_mixte}{flux naf artificialisation mixte}
#'   \item{flux_naf_artificialisation_total}{flux naf artificialisation total}
#' }
#' @source \url{https://agreste.agriculture.gouv.fr/agreste-web/disaron/W0020/detail/}
"observatoire_artificialisation"

#' Table contenant les métadonnées des indicateurs.
#'
#' @encoding UTF-8
#' @format  Table de 127 lignes et 5 colonnes:
#' \describe{
#'   \item{source}{Source d'origine de l'indicateur}
#'   \item{variable}{Nom de l'indicateur}
#'   \item{libelle_variable}{Libellé de l'indicateur}
#'   \item{unite}{Unité de mesure}
#'   \item{secret}{oui si source sous secret statistique}
#' }
#' @source \url{https://agreste.agriculture.gouv.fr/agreste-web/disaron/W0020/detail/}
"metadata_donnee"

#' Table contenant les différents indicateurs de l etalement urbain
#'
#' @encoding UTF-8
#' @format  Table de 1314 lignes et 5 colonnes:
#' \describe{
#'   \item{TypeZone}{Type de territoire}
#'   \item{CodeZone}{Code du territoire}
#'   \item{Zone}{Libellé du territoire}
#'   \item{date}{Millésime de la source}
#'   \item{indicateur_etalement_urbain}{indicateur etalement urbain}
#' }
#' @source \url{https://agreste.agriculture.gouv.fr/agreste-web/disaron/W0020/detail/}
"etalement_urbain"

#' Table contenant les différents indicateurs de la source stock_artificialise utiles pour la publication.
#'
#' @encoding UTF-8
#' @format  Table de 6570 lignes et 5 colonnes:
#' \describe{
#'   \item{TypeZone}{Type de territoire}
#'   \item{CodeZone}{Code du territoire}
#'   \item{Zone}{Libellé du territoire}
#'   \item{date}{Millésime de la source}
#'   \item{surface_artificialisee}{surface artificialisee}
#' }
#' @source \url{https://agreste.agriculture.gouv.fr/agreste-web/disaron/W0020/detail/}
"stock_artificialise"


#' Table contenant les différents indicateurs de la source population_legale utiles pour la publication.
#'
#' @encoding UTF-8
#' @format  Table de 690042 lignes et 5 colonnes:
#' \describe{
#'   \item{TypeZone}{Type de territoire}
#'   \item{CodeZone}{Code du territoire}
#'   \item{Zone}{Libellé du territoire}
#'   \item{date}{Millésime de la source}
#'   \item{population_municipale}{population minicipale}
#' }
#' @source \url{https://agreste.agriculture.gouv.fr/agreste-web/disaron/W0020/detail/}
"population_legale"

#' Table contenant les différents indicateurs de la source OCSGE pour la publication.
#'
#' @encoding UTF-8
#' @format  Table de 2632 lignes et 10 colonnes:
#' \describe{
#'   \item{TypeZone}{Type de territoire}
#'   \item{Zone}{Libellé du territoire}
#'   \item{CodeZone}{Code du territoire}
#'   \item{date}{Millésime de la source}
#'   \item{a_definir}{a definir}
#'   \item{autre_surface_naturelle}{autre surface naturelle}
#'   \item{espace_agricole}{espace agricole}
#'   \item{espace_artificialise}{espace artificialise}
#'   \item{surface_en_eau}{surface en eau}
#'   \item{surface_naturelle_boisee}{surface naturelle boisee}
#' }
#' @source \url{https://agreste.agriculture.gouv.fr/agreste-web/disaron/W0020/detail/}
"ocsge"


#' Table contenant les dates des millesimes les plus recents.
#'
#' @encoding UTF-8
#' @format  Table de 6 lignes et 2 colonnes:
#' \describe{
#'   \item{donnee}{Source d'origine}
#'   \item{date}{millesime}
#' }
"millesimes_disponibles"
