#' Creation du graphique de la chronologie estimant le temps necessaire au doublement des surfaces artificialisees.
#' @description Graphique de la chronologie estimant le temps necessaire au doublement des surfaces artificialisees.
#'
#' @param millesime_stock_artif une année parmi les millesimes sélectionnables par l'utilisateur, au format numerique.
#' @param code_reg code de la région sélectionnable par l'utilisateur.
#'
#' @return Un graphique
#'
#' @importFrom attempt stop_if stop_if_not
#' @importFrom COGiter filtrer_cog
#' @importFrom dplyr mutate filter select case_when arrange
#' @importFrom ggplot2 ggplot aes geom_point scale_x_continuous scale_y_continuous labs geom_hline theme element_rect geom_text
#' @importFrom glue glue
#' @importFrom lubridate year
#' @importFrom tidyr spread
#'
#' @export
#'
#' @examples
#' creer_graphe_5_1(millesime_stock_artif=2020,code_reg = "52")


creer_graphe_5_1 <- function(millesime_stock_artif,code_reg) {

  attempt::stop_if(millesime_stock_artif, is.null, msg = "millesime_stock_artif n\'est pas renseign\u00e9")
  attempt::stop_if_not(millesime_stock_artif, is.numeric, msg = "millesime_stock_artif n\'est pas un nombre")
  attempt::stop_if(code_reg, is.null, msg = "code_reg n\'est pas renseign\u00e9")
  attempt::stop_if_not(code_reg, ~ .x %in% levels(COGiter::regions$REG), msg = "code_reg n\'est pas un code r\u00e9gion valide")

  if (is.numeric(code_reg)) {
    code_reg = as.character(code_reg)
  }

  millesime_reference = 2016

  # creation de la fonction inverse
  `%notin%` <- Negate(`%in%`)

  if (code_reg %in% c('52')) {

  data <- stock_artificialise %>%
    dplyr::select (-.data$surf_cadastree) %>%
    COGiter::filtrer_cog(reg = code_reg) %>%
    dplyr::mutate(date=lubridate::year(.data$date)) %>%
    dplyr::filter(.data$TypeZone %in% c("D\u00e9partements"),
                  .data$date %in% c(millesime_stock_artif,millesime_reference)) %>%

    dplyr::select(.data$TypeZone,.data$Zone,.data$CodeZone,.data$date,.data$surface_artificialisee) %>%
    dplyr::mutate(surface_artificialisee = .data$surface_artificialisee / 10000) %>%
    dplyr::mutate(date = dplyr::case_when(
      .data$date == millesime_reference ~ "stock_mill_debut",
      .data$date == millesime_stock_artif ~ "stock_mill_fin",
      TRUE ~ "")
    ) %>%
    tidyr::spread(key=.data$date,value=.data$surface_artificialisee,fill=0)%>%
    dplyr::mutate(surf_artif_Xans=.data$stock_mill_fin-.data$stock_mill_debut,
                  surf_artif_par_an = .data$surf_artif_Xans / ( millesime_stock_artif - millesime_reference),
                  nb_annees_pour_doubler = ceiling(.data$stock_mill_debut / .data$surf_artif_par_an),
                  annee_de_doublement = millesime_reference + .data$nb_annees_pour_doubler,
                  rank = rank(.data$nb_annees_pour_doubler))%>%
    dplyr::arrange(.data$TypeZone,.data$Zone)

valeur_max <- max(sapply(data$annee_de_doublement, max, na.rm = TRUE))

  graph_5_1 <- data %>%
    ggplot2::ggplot(ggplot2::aes(x=.data$annee_de_doublement,y=0,color=.data$CodeZone)) +
    ggplot2::geom_point(size=10)+
    ggplot2::scale_x_continuous(limits = c(2020,valeur_max),breaks=seq(2020,valeur_max,by=20) )+
    ggplot2::scale_y_continuous(limits = c(-0.1, 0.1),breaks=seq(2020,valeur_max,by=10) )+
    ggplot2::labs(title=glue::glue("Estimation du temps n\u00e9cessaire pour doubler les surfaces cadastr\u00e9es consomm\u00e9es de {millesime_reference}"),
                  caption = glue::glue("Source : Cerema Fichiers fonciers"),
                  x="",fill="")+
    ggplot2::geom_hline(yintercept=0,
                        color = "white", size=0.8)+
    ggplot2::theme(
      panel.background = ggplot2::element_rect(fill = "grey",
                                               colour = "black",
                                               size = .5, linetype = "solid"),
      axis.text.y = ggplot2::element_blank(),
      axis.ticks.y=ggplot2::element_blank(),
      axis.title.y =ggplot2::element_blank()
    )+
    ggplot2::theme(legend.position = "none")+
    ggplot2::geom_text(ggplot2::aes(label = .data$CodeZone), color = "black", size=3)

return(graph_5_1)
  }
  if (code_reg  %notin% c('52')) {
    return(invisible(NULL))
  }

}
