#' Creation de la carte communale de l'etalement urbain
#' @description Carte communale de l'etalement urbain
#'
#' @param millesime_etalement_urbain une année parmi les millesimes sélectionnables par l'utilisateur, au format numerique.
#' @param police_annotation la police de caractère pour les annotations
#' @param code_reg code de la région sélectionnable par l'utilisateur.
#'
#' @return Une carte
#'
#' @import COGiter
#' @importFrom dplyr filter mutate pull
#' @importFrom forcats fct_rev fct_drop
#' @importFrom lubridate make_date
#' @importFrom mapfactory fond_carto creer_carte_categorie_communes
#' @importFrom ggplot2 annotate arrow unit labs theme
#' @importFrom glue glue
#' @importFrom sf st_centroid st_geometry st_coordinates st_point_on_surface
#' @importFrom attempt stop_if stop_if_not
#'
#' @export
#'
#' @examples
#' creer_carte_3_2(millesime_etalement_urbain = 2020,police_annotation = "sans", code_reg ="52")

creer_carte_3_2 <- function(millesime_etalement_urbain,
                            police_annotation = "sans",
                            code_reg = NULL) {

  attempt::stop_if(millesime_etalement_urbain, is.null, msg = "millesime_etalement_urbain n'est pas renseign\u00e9")
  attempt::stop_if_not(millesime_etalement_urbain, is.numeric, msg = "millesime_etalement_urbain n'est pas un nombre")
  attempt::stop_if(code_reg, is.null, msg = "code_reg n'est pas renseign\u00e9")
  attempt::stop_if_not(code_reg, ~ .x %in% levels(COGiter::regions$REG), msg = "code_reg n'est pas un code r\u00e9gion valide")

  if (is.numeric(code_reg)) {
    code_reg = as.character(code_reg)
  }

  millesime_etalement_urbain_debut <- millesime_etalement_urbain - 5 + 1 # période de 5 ans
  millesime_population <- millesime_etalement_urbain - 1

  # creation de la fonction inverse
  `%notin%` <- Negate(`%in%`)

  if (code_reg %in% c('52')) {

  data <- etalement_urbain %>%
    dplyr::filter(
      .data$TypeZone == "Communes",
      .data$date == lubridate::make_date(millesime_etalement_urbain, "01", "01")
    ) %>%
    dplyr::mutate(
      indicateur_etalement_urbain = as.character(.data$indicateur_etalement_urbain),
      indicateur_etalement_urbain = replace(.data$indicateur_etalement_urbain, .data$indicateur_etalement_urbain == "classe 1","\nL'artificialisation d\u00e9croit \net la population croit"),
      indicateur_etalement_urbain = replace(.data$indicateur_etalement_urbain, .data$indicateur_etalement_urbain == "classe 2a","\nL'artificialisation progresse\nmoins vite que la population"),
      indicateur_etalement_urbain = replace(.data$indicateur_etalement_urbain, .data$indicateur_etalement_urbain == "classe 2b", "\nL'artificialisation d\u00e9croit \nmoins vite que la population"),
      indicateur_etalement_urbain = replace(.data$indicateur_etalement_urbain, .data$indicateur_etalement_urbain == "classe 2c","\nL'artificialisation d\u00e9croit \nplus vite que la population"),
      indicateur_etalement_urbain = replace(.data$indicateur_etalement_urbain, .data$indicateur_etalement_urbain == "classe 3", "\nL'artificialisation progresse\nplus vite que la population"),
      indicateur_etalement_urbain = replace(.data$indicateur_etalement_urbain, .data$indicateur_etalement_urbain == "classe 4", "\nL'artificialisation progresse\nmoins vite que la population"),
      indicateur_etalement_urbain = replace(.data$indicateur_etalement_urbain, .data$indicateur_etalement_urbain == "classe 5", "\nL'artificialisation progresse\nplus vite que la population"),# idem 3
      indicateur_etalement_urbain = replace(.data$indicateur_etalement_urbain, .data$indicateur_etalement_urbain == "classe 6","\nL'artificialisation progresse \net la population d\u00e9croit")
      ) %>%
    dplyr::mutate(indicateur_etalement_urbain=as.factor(.data$indicateur_etalement_urbain))%>%
    dplyr::mutate(indicateur_etalement_urbain= forcats::fct_relevel(.data$indicateur_etalement_urbain,
                                                                    "\nL'artificialisation progresse \net la population d\u00e9croit", # classe 6
                                                                    "\nL'artificialisation progresse\nplus vite que la population", # classes 3 et 5
                                                                    "\nL'artificialisation progresse\nmoins vite que la population", # classe 2a et 4
                                                                    "\nL'artificialisation d\u00e9croit \nmoins vite que la population", # classe 2b
                                                                    "\nL'artificialisation d\u00e9croit \nplus vite que la population", # classe 2c
                                                                    "\nL'artificialisation d\u00e9croit \net la population croit" # classe 1
                                                                    )) %>%
    dplyr::arrange(.data$indicateur_etalement_urbain)

  nom_region <- COGiter::regions %>%
    dplyr::filter (.data$REG == code_reg) %>%
    dplyr::mutate(NCCENR = as.character(forcats::fct_drop(.data$NCCENR))) %>%
    dplyr::pull(.data$NCCENR)

  fond_carte <- mapfactory::fond_carto(nom_reg = nom_region)

  carte_3_2 <- mapfactory::creer_carte_categorie_communes(
    data = data,
    code_region = code_reg,
    carto = fond_carte,
    palette = "pal_gouv_div1",
    inverse = TRUE,
    indicateur = .data$indicateur_etalement_urbain,
    titre = glue::glue("Etalement urbain par commune entre {millesime_etalement_urbain_debut} et {millesime_etalement_urbain}"),
    bas_de_page = glue::glue("Source : Cerema Fichiers fonciers / Insee RP {millesime_population}"),
    suffixe = NULL
  ) +
    ggplot2::theme(legend.position = "right")


  return(carte_3_2)
  }
  if (code_reg  %notin% c('52')) {
    return(invisible(NULL))
  }
}
