#' Creation de la carte de l evolution des surfaces artificialisees par commune en pourcentage
#' @description Carte de l evolution des surfaces artificialisees par commune en pourcentage
#'
#' @param millesime_stock_artif une année parmi les millesimes sélectionnables par l'utilisateur, au format numerique.
#' @param code_reg code insee de la région sur laquelle construire le graphique
#'
#' @return Une carte regionale
#'
#' @importFrom attempt stop_if stop_if_not
#' @importFrom COGiter filtrer_cog
#' @importFrom dplyr mutate filter select arrange group_by lag ungroup pull
#' @importFrom forcats fct_drop
#' @importFrom glue glue
#' @importFrom lubridate year
#' @importFrom mapfactory fond_carto creer_carte_communes
#' @importFrom stats quantile
#'
#'
#' @export
#'
#' @examples
#' creer_carte_2_8(millesime_stock_artif = 2020, code_reg = 52)
#'
creer_carte_2_8 <- function(millesime_stock_artif = NULL,
                             code_reg = NULL) {
  attempt::stop_if(millesime_stock_artif, is.null, msg = "millesime_stock_artif n\'est pas renseign\u00e9")
  attempt::stop_if_not(millesime_stock_artif, is.numeric, msg = "millesime_stock_artif n\'est pas un nombre")
  attempt::stop_if(code_reg, is.null, msg = "code_reg n\'est pas renseign\u00e9")
  attempt::stop_if_not(code_reg, ~ .x %in% levels(COGiter::regions$REG), msg = "code_reg n\'est pas un code r\u00e9gion valide")

  millesime_debut <- 2016
  if (is.numeric(code_reg)) {
    code_reg = as.character(code_reg)
  }

  # creation de la fonction inverse
  `%notin%` <- Negate(`%in%`)

  if (code_reg %in% c('52')) {

  # Creation de la table utile a la production du graphique
  data <- stock_artificialise %>%
    dplyr::mutate(date = lubridate::year(.data$date)) %>%
    COGiter::filtrer_cog(reg = code_reg) %>%
    dplyr::filter(.data$TypeZone =="Communes",
                  .data$date == millesime_stock_artif | .data$date == millesime_debut) %>%
    dplyr::select (-.data$surf_cadastree) %>%
    dplyr::arrange(.data$TypeZone, .data$Zone, .data$CodeZone, .data$date) %>%
    dplyr::group_by(.data$TypeZone, .data$Zone, .data$CodeZone) %>%
    dplyr::mutate(valeur = round(.data$surface_artificialisee * 100 / dplyr::lag(.data$surface_artificialisee) - 100, 1)) %>%
    dplyr::ungroup() %>%
    dplyr::filter(.data$date == millesime_stock_artif) %>%
    dplyr::select(.data$TypeZone, .data$CodeZone, .data$Zone, .data$valeur)

  nom_region <- COGiter::regions %>%
    dplyr::filter (.data$REG == code_reg) %>%
    dplyr::mutate(NCCENR = as.character(forcats::fct_drop(.data$NCCENR))) %>%
    dplyr::pull(.data$NCCENR)

  fond_cartographique <- mapfactory::fond_carto(nom_reg = nom_region)

  # p <- c(0, 0.1, 0.25, 0.5, 0.75, 0.9, 1)
  # p <- c(0.30, 0.55, 0.75, 0.9, 1)
  p <- c(0.1, 0.25, 0.5, 0.75, 0.9)
  bins  <- stats::quantile(data$valeur, probs = p, na.rm=TRUE)


  carte_2_8 <- mapfactory::creer_carte_communes(data = data,
                                                code_region=code_reg,
                                                carto = fond_cartographique,
                                                indicateur = valeur,
                                                bornes = bins,
                                                decimales = 1,
                                                palette = "pal_gouv_h",
                                                titre = glue::glue("Evolution de la consommation des surfaces cadastr\u00e9es\n entre {millesime_debut} et {millesime_stock_artif} (en %)"),
                                                sous_titre = NULL,
                                                bas_de_page = glue::glue("Source : Cerema Fichiers fonciers"),
                                                suffixe = "%"
  )


  return(carte_2_8)
  }
  if (code_reg  %notin% c('52')) {
    return(invisible(NULL))
  }
}

