#' Creation de la carte regionale de l evolution des surfaces cadastrees
#' @description carte regionale de l evolution des surfaces cadastrees
#'
#' @param millesime_obs_artif une année parmi les millesimes sélectionnables par l'utilisateur, au format numerique.
#' @param code_reg code insee de la région sur laquelle construire le graphique
#'
#' @return une carte regionale
#'
#' @import COGiter
#' @importFrom dplyr mutate filter group_by summarise ungroup pull
#' @importFrom forcats fct_drop
#' @importFrom stats quantile
#' @importFrom glue glue
#' @importFrom lubridate year
#' @importFrom mapfactory creer_carte_communes fond_carto
#' @importFrom attempt stop_if stop_if_not
#'
#' @export
#'
#' @examples
#' creer_carte_2_7(millesime_obs_artif = 2020, code_reg ="52")

creer_carte_2_7 <- function(millesime_obs_artif= NULL, code_reg = NULL) {

  attempt::stop_if(millesime_obs_artif, is.null, msg = "millesime_obs_artif n\'est pas renseign\u00e9")
  attempt::stop_if_not(millesime_obs_artif, is.numeric, msg = "millesime_obs_artif n\'est pas un nombre")
  attempt::stop_if(code_reg, is.null, msg = "code_reg n\'est pas renseign\u00e9")
  attempt::stop_if_not(code_reg, ~ .x %in% levels(COGiter::regions$REG), msg = "code_reg n\'est pas un code r\u00e9gion valide")

  # calcul des millesimes de la carte
  millesime_debut <- millesime_obs_artif - 10
  millesime_fin <- millesime_obs_artif - 1

  if (is.numeric(code_reg)) {
    code_reg = as.character(code_reg)
  }

  # Creation de la table utile a la production du graphique
  data <- observatoire_artificialisation %>%
    dplyr::mutate(date = as.numeric(lubridate::year(.data$date))) %>%
    dplyr::filter(.data$TypeZone == "Communes",
                  .data$date <= millesime_obs_artif,
                  .data$date >= millesime_obs_artif - 9) %>%
    dplyr::mutate(flux_naf_artificialisation_total = .data$flux_naf_artificialisation_total / 10000) %>%
    dplyr::group_by(.data$CodeZone, .data$TypeZone, .data$Zone) %>%
    dplyr::summarise(valeur = sum(.data$flux_naf_artificialisation_total, na.rm = T)) %>%
    dplyr::ungroup()

  nom_region <- COGiter::regions %>%
    dplyr::filter (.data$REG == code_reg) %>%
    dplyr::mutate(NCCENR = as.character(forcats::fct_drop(.data$NCCENR))) %>%
    dplyr::pull(.data$NCCENR)

  fond_cartographique <- mapfactory::fond_carto(nom_reg = nom_region)
  # bins  <- stats::quantile(data$valeur,probs = c(0,0.1, 0.25, 0.5,0.75,0.9,1),na.rm=TRUE)
  bins  <- stats::quantile(data$valeur,probs = c(0,0.2, 0.4, 0.6,0.8,1),na.rm=TRUE)


  carte_2_7 <- mapfactory::creer_carte_communes(data = data,
                                                code_region=code_reg,
                                                carto = fond_cartographique,
                                                indicateur = valeur,
                                                bornes = bins,
                                                decimales = 1,
                                                palette = "pal_gouv_h",
                                                titre = glue::glue("Nouvelles surfaces cadastr\u00e9es consomm\u00e9es\nentre {millesime_debut} et {millesime_fin} (10 ans)"),
                                                sous_titre = NULL,
                                                bas_de_page = glue::glue("Source : Observatoire de l\'artificialisation {millesime_obs_artif}"),
                                                suffixe = "ha"
  )


  return(carte_2_7)
}
