#' Creation de la Carte de la part du territoire communal artificialise selon OCSGE
#' @description Carte de la part du territoire communal artificialise selon OCSGE
#'
#' @param millesime_ocsge une année parmi les millesimes sélectionnables par l'utilisateur, au format numerique.
#' @param code_reg code insee de la région sur laquelle construire le graphique
#'
#' @return Une carte
#'
#' @importFrom dplyr filter mutate arrange group_by summarise ungroup select
#' @importFrom glue glue
#' @importFrom lubridate make_date month
#' @importFrom stats quantile
#' @importFrom mapfactory fond_carto creer_carte_communes
#' @importFrom tidyr gather
#' @importFrom attempt stop_if stop_if_not message_if_not
#'
#' @export
#'
#' @examples
#' creer_carte_1_7(millesime_ocsge=2016, code_reg = '52')


creer_carte_1_7 <- function(millesime_ocsge,
                            code_reg){


  attempt::stop_if(millesime_ocsge, is.null, msg = "millesime_ocsge n'est pas renseign\u00e9")
  attempt::stop_if_not(millesime_ocsge, is.numeric, msg = "millesime_ocsge n'est pas un nombre")
  attempt::stop_if(code_reg, is.null, msg = "code_reg n'est pas renseign\u00e9")
  if (is.numeric(code_reg)) {
    code_reg = as.character(code_reg)
  }

  # creation de la fonction inverse
  `%notin%` <- Negate(`%in%`)

  if (code_reg %in% c('52')) {

  data <- ocsge %>%
    dplyr::filter(grepl(millesime_ocsge, .data$date),
                  .data$TypeZone == "Communes")

  mois <- lubridate::month(data[1,"date"],label=TRUE)

  data <- data %>%
    tidyr::gather(variable,valeur,.data$a_definir:.data$surface_naturelle_boisee) %>%
    dplyr::arrange(.data$CodeZone) %>%
    dplyr::group_by(.data$TypeZone,.data$Zone,.data$CodeZone,.data$date)  %>%
    dplyr::summarise(variable=.data$variable,valeur=.data$valeur / sum(.data$valeur,na.rm=T))  %>%
    dplyr::filter(.data$variable == "espace_artificialise") %>%
    dplyr::ungroup() %>%
    dplyr::select(.data$TypeZone,.data$CodeZone,.data$Zone,.data$date,.data$valeur) %>%
    dplyr::mutate(valeur=.data$valeur * 100)

  nom_region <- COGiter::regions %>%
    dplyr::filter (.data$REG == code_reg) %>%
    dplyr::mutate(NCCENR = as.character(forcats::fct_drop(.data$NCCENR))) %>%
    dplyr::pull(.data$NCCENR)

  fond_carto <- mapfactory::fond_carto(nom_reg = nom_region)
  bins  <- stats::quantile(data$valeur,probs = c(0,0.1, 0.25, 0.5,0.75,0.9,1),na.rm=TRUE)

  carte_1_7 <- mapfactory::creer_carte_communes(data = data,
                                                code_region=code_reg,
                                                carto = fond_carto,
                                                indicateur = valeur,
                                                bornes = bins,
                                                pourcent = TRUE,
                                                decimales = 1,
                                                palette = "pal_gouv_h",
                                                titre =  glue::glue("Part du territoire communal artificialis\u00e9 en {mois} {millesime_ocsge}"),
                                                sous_titre = NULL,
                                                bas_de_page = glue::glue("Source : OCSGE {millesime_ocsge}"),
                                                suffixe = NULL
  )

  return(carte_1_7)
  }
  if (code_reg  %notin% c('52')) {
    return(invisible(NULL))
  }
}
