#' Creation de la Carte communale regionale de l'artificialisation en volume selon OCSGE
#' @description Carte communale regionale de l'artificialisation en volume selon OCSGE
#'
#' @param millesime_ocsge une année parmi les millesimes sélectionnables par l'utilisateur, au format numerique.
#' @param code_reg code insee de la région sur laquelle construire le graphique
#'
#' @return Une carte
#'
#' @import COGiter
#' @importFrom dplyr filter mutate select
#' @importFrom glue glue
#' @importFrom mapfactory creer_carte_communes_prop fond_carto
#' @importFrom attempt stop_if stop_if_not message_if_not
#' @importFrom lubridate month
#'
#' @export
#'
#' @examples
#' creer_carte_1_3(millesime_ocsge=2016, code_reg = '52')


creer_carte_1_3 <- function(millesime_ocsge,code_reg){

  if (is.numeric(code_reg)) {
    code_reg = as.character(code_reg)
  }
  attempt::stop_if(millesime_ocsge, is.null, msg = "millesime_ocsge n'est pas renseign\u00e9")
  attempt::stop_if_not(millesime_ocsge, is.numeric, msg = "millesime_ocsge n'est pas un nombre")
  attempt::stop_if(code_reg, is.null, msg = "code_reg n'est pas renseign\u00e9")

  # creation de la fonction inverse
  `%notin%` <- Negate(`%in%`)

  if (code_reg %in% c('52')) {
  data <- ocsge %>%
    dplyr::filter(grepl(millesime_ocsge, .data$date)) %>%
    dplyr::select(.data$TypeZone,.data$Zone,.data$CodeZone,.data$date,.data$espace_artificialise) %>%
    dplyr::mutate(valeur=round(.data$espace_artificialise / 10000,0)) %>%
    dplyr::select(-.data$espace_artificialise)

  mois <- lubridate::month(data[1,"date"],label=TRUE)

  nom_region <- COGiter::regions %>%
    dplyr::filter (.data$REG == code_reg) %>%
    dplyr::mutate(NCCENR = as.character(forcats::fct_drop(.data$NCCENR))) %>%
    dplyr::pull(.data$NCCENR)

  fond_carto <- mapfactory::fond_carto(nom_reg = nom_region)

  carte_1_3 <- mapfactory::creer_carte_communes_prop(data = data,
                                                     code_region = code_reg,
                                                     carto = fond_carto,
                                                     indicateur = valeur,
                                                     pourcent = FALSE,
                                                     decimales=0,
                                                     palette = "pal_gouv_h",
                                                     max_size = 15,
                                                     suffixe = "hectares",
                                                     interactive = FALSE,
                                                     titre = glue::glue("Etat des espaces artificialis\u00e9s par communes en {mois} {millesime_ocsge}"),
                                                     bas_de_page = glue::glue("Source : OCSGE {millesime_ocsge}")
                                                     )


  return(carte_1_3)
  }
  if (code_reg  %notin% c('52')) {
    return(invisible(NULL))
  }
}
