

ui<-dashboardPage(title = "Filocubes - Dreal datalab", # personnalisation du thème
              
              # En-tête
              dashboardHeader(title = ""),

              #-----------------------------------------------------------------------------              
              # Barre de menu
              dashboardSidebar(
                  
                  # Menu avec la liste des onglets
                  sidebarMenu(
                      tags$br(),
                      tags$br(),
                      # menuItem("Accueil", tabName = "ongletA", icon = icon("child")),
                      menuItem("Filocubes", tabName = "Filocubes", icon = icon("bar-chart-o")),
                      menuItem("Mentions l\u00e9gales",tabName = "mentionlegale",icon=icon("gavel")),
                      tags$br(),
                      tags$br(),
                      tags$br(),
                      tags$br(),
                      tags$br(),
                      tags$br(),
                      tags$br(),
                      tags$br(),
                      tags$img(src="Logo_datalab_white.png",width="150px",style="display: block; margin-left: auto; margin-right: auto;"),
                      tags$br(),
                      tags$img(src="logo_prefet.jpg", width="150px",style="display: block; margin-left: auto; margin-right: auto;")
                      
                      
                  )
              ),
              dashboardBody(
                  #ajout du texte dans le bandeau du haut 
                  tags$head(tags$style(HTML(
                      '.myClass { 
           font-size: 20px;
           line-height: 50px;
           text-align: left;
           font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
           padding: 0 15px;
           overflow: hidden;
           color: white;
         }
       '))),
                  tags$script(HTML('
         $(document).ready(function() {
           $("header").find("nav").append(\'<span class="myClass"> Filocubes </span>\');
         })
        ')),      
                  
                  dreal_golem_add_ext(),    #template DREAL
                  
                  # empeche l'affichage des warning avant l'affichage des tableaux
                  tags$style(type="text/css",
                             ".shiny-output-error { visibility: hidden; }",
                             ".shiny-output-error:before { visibility: hidden; }"
                  ),         
                  
                  
                  # Contenu de chacun des onglets
                  tabItems( 
                  #--------------------------Accueil---------------------------------------------------
                  # tabItem(tabName = "ongletA",
                  #         tags$h1("R\u00e9ponse \u00e0 la demande - DREAL DATA LAB",align="center"),
                  #         tags$br(),
                  #         tags$br(),
                  #         tags$br(),
                  #         tags$br(),
                  #         
                  #     fluidRow(width=12,
                  #              column(width=1),
                  #              column(width=5,
                  #         tags$h2("Application Shiny destin\u00e9e aux DREAL et DDT, afin de simplifier la production de donn\u00e9es 
                  #         aussi bien pour la r\u00e9ponse aux demandes de leurs partenaires que pour leurs besoins propres."),
                  #         tags$br()
                  #              ),
                  #              column(width=6,
                  #         tags$br(),
                  #         div(tags$img(src="people.jpg",height="100%",width="70%",deletefile=FALSE), style="text-align: center;")
                  #              )
                  #         
                  #        )  
                  # ),
                  
                  
                  #--------------------------Filocubes---------------------------------------------------
                  tabItem(tabName = "Filocubes",
                          tags$h1("Cubes Filocom",align="center"),
                          tags$div(
                            HTML(paste(span(style="font-size: 18px", "Interface simplifiée pour l'exploitation des données FILOCOM issues des cubes secrétisés."))),style="color:#00465A",align="center"
                          ),
                          
                    fluidRow(width=12       
                    ),
                    fluidRow(width=12,
                    column(width=7, #debut de la 1ere colonne (selection et donnees a extraire)
                    
                    
                    fluidRow(width=12,
                          column(width=1),
                             
                          column(width=5,
                                 tags$h3("S\u00e9lection",align="left"),  
                                 ),
                          column(width=6,
                                 tags$h3("Donn\u00e9es \u00e0 extraire",align="left"), 
                                 )     
                    ),
                    fluidRow(width=12,       
                             column(width=1),
                             
                             column(width=5,
                                    # sélecteur de millésime
                                    selectInput(inputId = "mill",
                                                label = "mill\u00e9sime :",	
                                                choices = c(2019,2017,2015,2013,2011,2009,2007),	
                                                selected = 2019)  
                             ),
                             column(width=6,
                                    checkboxGroupInput("valid_france","",c("France m\u00e9tropolitaine"="fr_metro","Outre-mer"="o_mer"))
                             )
                    ),
                    fluidRow(width=12,       
                             column(width=1),
                             
                             column(width=5,
                                    # sélecteur région
                                    selectInput(inputId = "ma_reg",
                                                label = "S\u00e9lectionner une r\u00e9gion :",	
                                                choices = liste_reg,	
                                                selected = "Pays de la Loire") 
                             ),
                             column(width=6,
                                    radioButtons("valid_reg","",c("r\u00e9gion"="reg1","aucune"="reg0"))
                             )                           
                    ),                   
                    fluidRow(width=12,       
                             column(width=1),
                             
                             column(width=5,
                                    #  sélecteur département
                                    uiOutput('dep_selection')  
                             ),
                             column(width=6,
                                    radioButtons("valid_dep","",c("d\u00e9partement"="dep1","tous les d\u00e9partements de la r\u00e9gion"="dep2","aucun"="dep0"))
                             )                           
                    ),                    
                    
                    fluidRow(width=12,       
                             column(width=1),
                             
                             column(width=5,
                                    #  sélecteur de l'EPCI, dépendant du département
                                    uiOutput('epci_selection'),
                                    textOutput("texte1")
                             ),
                             column(width=6,
                                    radioButtons("valid_epci","",c("Epci"="epci1","tous les Epci du d\u00e9partement"="epci2","tous les Epci de la r\u00e9gion"="epci3","aucun"="epci0"))
                             )                            
                    ),
                    fluidRow(width=12,
                        column(width=1),
                        column(width=5,
                               tags$br(),
                               tags$br(),   
                            # tags$h3("Communes",align="center",style="color:#00465A"),
                            tags$b(div("Communes",style="text-align:center ; font-family: \'Arial\' ;font-size: 16px; color: #008CA0"))
                        ),
                    column(width=6,
                           radioButtons("valid_com","",c("toutes les communes de l\'Epci"="com1","toutes les communes du d\u00e9partement"="com2","toutes les communes de la r\u00e9gion"="com3","aucune"="com0")) 
                    )    
                    )
                    
                    
                    ), #fin de la 1ere colonne (selection et donnees a extraire)
                    
                    column(width=5, #debut de la 2e colonne (telechargement)
                           tags$h3("T\u00e9l\u00e9chargement",align="left"),
                           tags$br(),
                           tags$br(),
                           # sélecteur de cube
                           selectInput(inputId = "mon_cube",
                                       label = "S\u00e9lectionner un cube :",
                                       choices = num_fichiers,	
                                       selected = "01"),
                           span(textOutput("libelle_cube"),style="font-size: 12px; color: #00465A"),
                           tags$br(),
                           downloadButton(outputId ="download_cubes",label="T\u00e9l\u00e9charger le cube"),
                           span("(fichier CSV , encodage UTF-8)",style="font-size: 12px; color: #00465A"),
                           tags$br(),
                           downloadButton(outputId ="download_cubes2",label="T\u00e9l\u00e9charger tous les cubes"),
                           tags$br(), 
                           tags$br(),
                           actionButton("pdf","Documentation des cubes", onclick = "window.open(\'Guide_utilisateur_Cubes_filocom_2019.pdf\')",
                                        icon("book-open"),style="color: #fff; background-color: #008CA0; border-color: #2e6da4"),
                           # downloadButton(outputId ="download_pdf",label="")  %>% 
                           #     bs_embed_popover(title="T\u00e9l\u00e9charger la documentation"),
                           tags$br(),
                           actionButton("pdf","Arr\u00eat\u00e9 Filocom", onclick = "window.open(\'Arrete-Filocom.pdf\')",
                                        style="font-size: 14px; font-weight : bold; text-decoration: underline; color: #008CA0"), 
                           actionButton("pdf","Compl\u00e9ments 2019", onclick = "window.open(\'Complements_Cubes_Filocom_2019.pdf\')",
                                        style="font-size: 14px; font-weight : bold; text-decoration: underline; color: #008CA0"),
                           tags$br(),
                           tags$br(),
                           box(status="primary", solidHeader = TRUE, width=7,collapsible =TRUE,collapsed = TRUE,
                               title = span("Règles de diffusion",style="font-size: 14px"),
                               tags$b(tags$h6("- Les données Filocom sont secrétisées conformément aux règles appliquées sur les données fiscales. Ces règles de diffusion sont détaillées dans la documentation disponible ci-dessus (p40 à 42)." ,align="left")),
                               tags$b(tags$h6("- Ces données Filocom peuvent être diffusées aux collectivités sans avoir à établir un acte d’engagement de confidentialité. Cependant, le demandeur doit être informé qu'il ne peut pas rediffuser ces tableaux de données et que l'utilisation des données doit faire mention de la source : FILOCOM - SDES." ,align="left"))
                           ),
                           tags$br(),
                           tags$br(),
                           tags$br(),
                           tags$br(),
                           tags$br(),
                           tags$em(div("A noter: Le cube 11 n\'est disponible que pour 2015, 2017 et 2019. Les cubes 7, 8, 9a et 9b ne sont pas disponibles pour 2007. Le cube 10 n\'est pas disponible pour 2007 et 2009",style="text-align:left ; font-family: \'Arial\' ;font-size: 16px; color: black")),
                           
                           
                           
                    ) #fin de la 2eme colonne (telechargement)
                   ),
                   
                    fluidRow(width=12, #debut du tableau
                             tags$br(),
                             tags$div(
                               HTML(paste("&nbsp;", span(style="font-size: 24px", "Aper\u00e7u du r\u00e9sultat du Cube "), span(style="font-size: 19px", "(Source : FILOCOM - SDES)"))),style="color:#8246AA"
                             ),
                             tags$br(),
                             DT::dataTableOutput('tableau'),
                             tags$br(),
                             tags$br(),
                             tags$br(),
                             tags$br()
                    )
                          
                  ),
                  #------------MENTIONS LEGALES-----------------------------------------------------------------                    
                  tabItem(tabName = "mentionlegale",
                          
                          fluidRow(
                              box(width=12,includeMarkdown("mentionlegale.md"))
                          )
                  )
                  )
                  
                  
                  
                  
                  

              )
)

shinymanager::secure_app(ui,
                         # fab_position = "top-right",
                         background  = "linear-gradient(rgba(0, 70, 90, 1),
        rgba(0, 190, 190, 1))",
                         tags_top =
                           tags$div(
                             tags$img(
                               src = "Logo_datalab_100.jpg", width = 100
                             )
                           ),
                         enable_admin = TRUE)
