
ui <-
  shinygouv::navbarPage_dsfr(
    title = "Filocubes",
    id = "nav",
    header = header_dsfr(
      intitule = c("Préfet", "de la région", "Pays de la Loire"),
      nom_site_service = tags$h1("Filocubes", align = "center"),
      baseline = "Interface simplifiée pour l'exploitation des données agrégées secretisées issues de la base FILOCOM."
    ),
    navbarPanel_dsfr(
      title = "Filocom (millésime 2022)",
      # empeche l'affichage des warnings avant l'affichage des tableaux
      tags$style(
        type = "text/css",
        ".shiny-output-error { visibility: hidden; }",
        ".shiny-output-error:before { visibility: hidden; }"
      ),
      
      fluidRow_dsfr(
        column_dsfr(
          width = 8, # debut de la 1ere colonne (selection et donnees a extraire)

          fluidRow_dsfr(
            column_dsfr(
              width = 5,
              h3("S\u00e9lection", align = "left"),
              # Adding space to the column
              extra_class = "fr-px-1w"
            ),
            column_dsfr(
              width = 7,
              h3("Donn\u00e9es \u00e0 extraire", align = "left"),
              # Adding space to the column
              extra_class = "fr-px-1w"
            )
          ),
          fluidRow_dsfr(
            column_dsfr(
              width = 5,
              # sélecteur de millésime
              selectInput_dsfr(
                inputId = "mill",
                label = "ann\u00e9e :",
                choices = c("2022","2021","2019", "2017", "2015", "2013", "2011", "2009"),
                selected = "2022"
              ),
              # Adding space to the column
              extra_class = "fr-px-1w"
            ),
            column_dsfr(
              width = 7,
              checkboxGroupInput_dsfr("valid_france", "", c("France m\u00e9tropolitaine" = "fr_metro", "Outre-mer" = "o_mer")),
              # Adding space to the column
              extra_class = "fr-px-1w"
            )
          ),
          fluidRow_dsfr(
            column_dsfr(
              width = 5,
              # sélecteur région
              selectInput_dsfr(
                inputId = "ma_reg",
                label = "r\u00e9gion :",
                choices = liste_reg,
                selected = "52"
              ),
              # Adding space to the column
              extra_class = "fr-px-1w"
            ),
            column_dsfr(
              width = 7,
              radioButtons_dsfr("valid_reg", "", c("r\u00e9gion" = "reg1", "aucune" = "reg0"),selected = "reg1"),
              # Adding space to the column
              extra_class = "fr-px-1w"
            )
          ),
          fluidRow_dsfr(
            column_dsfr(
              width = 5,
              #  sélecteur département
              uiOutput("dep_selection"),
              # Adding space to the column
              extra_class = "fr-px-1w"
            ),
            column_dsfr(
              width = 7,
              radioButtons_dsfr("valid_dep", "", c("d\u00e9partement" = "dep1", "tous les d\u00e9partements de la r\u00e9gion" = "dep2", "aucun" = "dep0"),selected = "dep1"),
              # Adding space to the column
              extra_class = "fr-px-1w"
              )
          ),
          fluidRow_dsfr(
            column_dsfr(
              width = 5,
              #  sélecteur de l'EPCI, dépendant du département
              uiOutput("epci_selection"),
              textOutput("texte1"),
              # Adding space to the column
              extra_class = "fr-px-1w"
            ),
            column_dsfr(
              width = 7,
              radioButtons_dsfr("valid_epci", "", c("Epci" = "epci1", "tous les Epci du d\u00e9partement" = "epci2", "tous les Epci de la r\u00e9gion" = "epci3", "aucun" = "epci0"),selected = "epci2"),
              # Adding space to the column
              extra_class = "fr-px-1w"
            )
          ),
          fluidRow_dsfr(
            column_dsfr(
              width = 5,
              tags$br(),
              tags$br(),
              tags$div("communes", style = "text-align:center ; font-size: 15px"),
              # Adding space to the column
              extra_class = "fr-px-1w"
            ),
            column_dsfr(
              width = 7,
              radioButtons_dsfr("valid_com", "", c("toutes les communes de l\'Epci" = "com1", "toutes les communes du d\u00e9partement" = "com2", "toutes les communes de la r\u00e9gion" = "com3", "aucune" = "com0"), selected = "com0"),
              # Adding space to the column
              extra_class = "fr-px-1w"
            )
          ),
          # Adding space to the column
          extra_class = "fr-my-1w"
        ), # fin de la 1ere colonne (selection et donnees a extraire)

        column_dsfr(
          width = 4, # debut de la 2e colonne (telechargement)
          # Adding space to the column
          extra_class = "fr-my-1w",
          tags$h3("T\u00e9l\u00e9chargement", align = "left"),
          # sélecteur de cube
          selectInput_dsfr(
            inputId = "mon_cube",
            label = "S\u00e9lectionner un cube :",
            choices = as.character(num_fichiers),
            selected = "01"
          ),
          span(textOutput("libelle_cube"), style = "font-size: 12px; color: #00465A"),
          tags$br(),
          downloadButton(outputId = "download_cubes", label = "T\u00e9l\u00e9charger le cube"),
          span("(fichier CSV , encodage UTF-8)", style = "font-size: 12px; color: #00465A"),
          tags$br(),
          downloadButton(outputId = "download_cubes2", label = "T\u00e9l\u00e9charger tous les cubes"),
          tags$br(),
          tags$br(),
          tags$a(class="btn fr-m-1w", href="Guide_utilisateur_cubes_filocom.pdf", "Documentation des cubes", target="_blank"),
          tags$br(),
          tags$a(class="btn fr-m-1w", href="Arrete-Filocom.pdf", "Arr\u00eat\u00e9 Filocom", target="_blank"),
          tags$br(),
          tags$a(class="btn fr-m-1w", href="Complements_Cubes_Filocom_2022.pdf", "Compl\u00e9ments 2022", target="_blank"),
          tags$br(),
          tags$br(),
          actionButton_dsfr("regles_diff", "Règles de diffusion"),
          tags$br(),
          tags$br(),
          tags$em(div("A noter: Les cubes décrivent le parc des logements au 1er janvier des années impaires 2009 à 2021 ainsi que 2022.  Pour les cubes 10 et 11, l'historique débute respectivement en 2011 et 2015.", style = "text-align:left ; font-family: \'Arial\' ;font-size: 16px; color: black")),
          tags$em(div("Une version de la série du nombre de familles monoparentales sans la rupture observée entre 2019 et 2021 dans les cubes 4a, 9a, 11, 13 et 17a est disponible dans les cubes éponymes suffixés par \"fmonop\".", style = "text-align:left ; font-family: \'Arial\' ;font-size: 16px; color: black")),
          tags$em(div(" Pour plus de détails, se référer au document \"Compléments relatifs aux cubes Filocom du millésime 2022\"", style = "text-align:left ; font-family: \'Arial\' ;font-size: 16px; color: black"))
                            ) # fin de la 2eme colonne (telechargement)
      ),
      fluidRow_dsfr( # debut du tableau
        tags$br(),
        tags$h2("Aper\u00e7u du r\u00e9sultat du Cube (Source : FILOCOM - SDES)"),
        tags$br(),
        DT::dataTableOutput("tableau"),
        tags$br(),
        tags$br(),
        tags$br(),
        tags$br()
      )
    ),
    
    #--------------------------Zones d'emploi et Unités Urbaines---------------------------------------------------    
    navbarPanel_dsfr(
      title = "ZE et UU",
      
      fluidRow_dsfr(
        column_dsfr(
          width = 12, # debut de la 2e colonne (telechargement)
          # Adding space to the column
          extra_class = "fr-my-1w",
          tags$h3("T\u00e9l\u00e9chargement France enti\u00e8re", align = "left"),
          # sélecteur de millésime
          selectInput_dsfr(
            inputId = "mill2",
            label = "ann\u00e9e :",
            choices = c("2022","2021","2019", "2017", "2015", "2013", "2011", "2009"),
            selected = "2022"
          )
        )      
      ),
      fluidRow_dsfr(
               column_dsfr(width=4,
                      tags$br(),
                      tags$h3("Zones d'Emploi",align="left"),
                      downloadButton(outputId ="download_cubes10",label="T\u00e9l\u00e9charger tous les cubes"),
                      extra_class = "fr-px-1w"),
               column_dsfr(width=8,
                      tags$br(),
                      tags$h3("Unit\u00e9s Urbaines",align="left"),
                      downloadButton(outputId ="download_cubes20",label="T\u00e9l\u00e9charger tous les cubes"),
                      extra_class = "fr-px-1w"),
      )
      ),
    #----------------
    navbarPanel_dsfr(
      title = "Mentions l\u00e9gales",
      br(),
      includeMarkdown("mentionlegale.md")
      
    )
  )


shinymanager::secure_app(ui,
                         status = "primary",
                         language = "fr",
                         theme = "dsfr.min.css",
                         tags_top =
                           tags$div(
                             tags$img(
                               src = "Logo_datalab_100.jpg", width = 100
                             )
                           ),
                         enable_admin = TRUE
)
