
shinyServer(function(input, output) {
  # securisation de l'application
  res_auth <- secure_server(
    check_credentials = check_credentials("database.sqlite")
  )

  # création des listes de choix------------------------------------

  # nommage du résultat du choix du millesime
  millesime <- reactive({
    mill <- as.numeric(input$mill)
  })

  # nommage des résultats du filtre région
  # region_code <- reactive({
  #   reg <- as.character(regions$REG[match(input$ma_reg, regions$NOM_REG)])
  # })
  # region_libelle <- reactive({
  #   reg <- input$ma_reg
  # })
  region_libelle <- reactive({
    reg <- as.character(regions$REG[match(input$ma_reg, regions$REG)])
  })
  region_code <- reactive({
    reg <- input$ma_reg
  })

  # création liste codes des départements
  liste_dep <- reactive({
    as.character(list_dep_in_reg(region_code()))
  })

  # création liste noms des départements
  liste_dep2 <- reactive({
    as.character(departements$NOM_DEP[match(liste_dep(), departements$DEP)])
  })

  # Création liste des départements
  output$dep_selection <- renderUI({
    selectInput(
      inputId = "dep_selection", label = "d\u00e9partement",
      choices = liste_dep2()
    )
  })

  # nommage des résultats du filtre département
  departement_code <- reactive({
    dep <- as.character(departements$DEP[match(input$dep_selection, departements$NOM_DEP)])
  })
  departement_libelle <- reactive({
    dep <- input$dep_selection
  })

  # création liste codes des epci
  liste_epci <- reactive({
    as.character(list_epci_in_dep(departement_code()))
  })

  # création liste noms des epci
  liste_epci2 <- reactive({
    as.character(epci$NOM_EPCI[match(liste_epci(), epci$EPCI)])
  })

  # Création liste des epci
  output$epci_selection <- renderUI({
    selectInput(
      inputId = "epci_selection", label = "EPCI",
      choices = liste_epci2()
    )
  })

  # nommage des résultats du filtre EPCI
  epci_code <- reactive({
    epci <- as.character(epci$EPCI[match(input$epci_selection, epci$NOM_EPCI)])
  })
  epci_libelle <- reactive({
    epci <- input$epci_selection
  })

  # renvoi du code EPCI
  output$texte1 <- renderText({
    epci_code()
  })

  # Fonction de création des datamart filtré
  creer_cube_00 <- function(x) {
    cube <- x %>%
      # filter (annee == millesime(), REG != "NULL")
      # on enleve les lignes ZE et UU
      filter(annee == millesime(), TypeZone != "ZE", TypeZone != "UU")

    # condition sur le national
    cube <- if (is.null(input$valid_france)) { # si rien n'est coché
      cube %>% filter(TypeZone != "NATIONAL") # on enlève les lignes NATIONAL
    } else if (length(input$valid_france) == 1) { # si une seule case cochée
      if (input$valid_france == "fr_metro") { # si que france métrop
        cube %>% filter(CodeZone != "N2") # on enlève les lignes outre mer
      } else if (input$valid_france == "o_mer") { # si que outre mer
        cube %>% filter(CodeZone != "N1") # on enlève les lignes france métrop
      }
    } else { # sinon , donc si on a 2 cases cochees
      cube # on garde tout
    }

    # condition sur la région
    cube <- if (input$valid_reg == "reg0") { # si selection "aucune r\u00e9gion"
      cube %>% filter(TypeZone != "REG") # on enlève les lignes régions
    } else {
      cube %>% filter(TypeZone != "REG" | REG == region_code())
    } # sinon on garde ce qui n'est pas region et la region selectionnee

    # condition sur le département
    cube <- if (input$valid_dep == "dep0") { # si selection "aucun d\u00e9partement"
      cube %>% filter(TypeZone != "DEP") # on enlève les lignes département
    } else if (input$valid_dep == "dep1") { # si selection que département sélectionné
      cube %>% filter(TypeZone != "DEP" | CodeZone == departement_code()) # on garde ce qui n'est pas département ou la ligne du département
    } else { # tous les departements
      cube %>% filter(TypeZone != "DEP" | grepl(region_code(), REG))
    } # sinon on garde ce qui n'est pas departement ou les departements de la region

    # condition sur l'EPCI
    cube <- if (input$valid_epci == "epci0") {
      cube %>% filter(TypeZone != "EPCI")
    } else if (input$valid_epci == "epci1") { # uniquement l'epci selectionne
      cube %>% filter(TypeZone != "EPCI" | CodeZone == epci_code())
    } else if (input$valid_epci == "epci2") { # tous les epci du departement
      cube %>% filter(TypeZone != "EPCI" | grepl(departement_code(), DEP), !grepl(paste0("9", departement_code()), DEP)) # tous les epci du département
    } else { # tous les epci de la region
      cube %>% filter(TypeZone != "EPCI" | grepl(region_code(), REG))
    } # sinon on garde ce qui n'est pas de l'epci ou les epci de la region

    # condition sur la commune
    cube <- if (input$valid_com == "com0") {
      cube %>% filter(TypeZone != "COM")
    } else if (input$valid_com == "com1") {
      # cube %>% filter( TypeZone != "COM" | EPCI == epci_code() ) #toutes les communes de l'EPCI
      cube %>% filter(TypeZone != "COM" | grepl(epci_code(), EPCI)) # toutes les communes de l'EPCI
    } else if (input$valid_com == "com2") {
      # cube %>% filter( TypeZone != "COM" | grepl(departement_code(), DEP)) #toutes les communes du département
      cube %>% filter(TypeZone != "COM" | grepl(departement_code(), DEP), !grepl(paste0("9", departement_code()), DEP)) # toutes les communes du département
    } else {
      cube %>% filter(TypeZone != "COM" | grepl(region_code(), REG))
    } # toutes les communes de la region

    cube <- cube %>% select(-DEP, -REG) # Enlever des colonnes qui comportent des listes et empechent l'export en csv
  }

  # tableau-------------------------------------------------------------------------------------------

  # # cube sélectionné
  cube_selection <- reactive({
    cube <- df_liste[[input$mon_cube]] %>%
      as.data.frame()
  })

  cube00 <- reactive({
    creer_cube_00(cube_selection())
  })

  # Renvoi du tableau
  output$tableau <- DT::renderDataTable(
    cube00(),
    # options = list(scrollX = TRUE,
    #                list(language = list(url = '//cdn.datatables.net/plug-ins/1.10.11/i18n/French.json')))
    options = list(
      language = list(url = "//cdn.datatables.net/plug-ins/1.10.11/i18n/French.json"),
      scrollX = TRUE
    )
  )

  # téléchargements-------------------------------------------------------------------------------------------

  # numero et libelle du cube
  num_cube <- reactive({
    input$mon_cube
  })
  libelle_cube <- reactive({
    tableau_liste_num %>%
      filter(x == num_cube()) %>%
      pull(y)
  })

  # renvoi du nom du cube
  output$libelle_cube <- renderText({
    libelle_cube()
  })


  # exportation des données
  output$download_cubes <-
    downloadHandler(
      filename = function() {
        paste("cube ", millesime(), "-", input$mon_cube, ".csv", sep = "")
      },
      content = function(file) {
        # cube000 <- creer_cube_00(cube_00())
        cube000 <- cube00()
        write.table(cube000, file, row.names = FALSE, quote = FALSE, sep = ";", fileEncoding = "UTF-8")
      }
    )

  # telechargement tous les cubes
  output$download_cubes2 <- downloadHandler(
    file <- function() {
      paste0("Xcubes-", millesime(), ".zip") # nommage du fichier zip
    },
    content = function(file) {
      # aller dans un repertoire temporaire
      owd <- setwd(tempdir())
      on.exit(setwd(owd))
      files <- NULL # initialisation de la variable dans laquelle sera stockee les noms des fichiers

      for (i in num_fichiers) {
        # ecrire chaque cube dans un csv, sauver le nom
        # fileName <- paste(i,".csv",sep = "")
        fileName <- paste("cube ", millesime(), "-", i, ".csv", sep = "")
        cube_i <- df_liste[[i]] %>%
          as.data.frame()       
        cubei <- creer_cube_00(cube_i)
        write.table(cubei, fileName, row.names = FALSE, quote = FALSE, sep = ";", fileEncoding = "UTF-8")
        files <- c(fileName, files) # ajout le nom du csv aux précedents
      }
      zip(file, files)
    }
  )


  # telechargement du PDF
  output$download_pdf <- downloadHandler(
    filename = "guide_utilisateur_cubes_filocom_2019.pdf",
    content = function(file) {
      file.copy("www/Guide_utilisateur_Cubes_filocom_2019.pdf", file)
    }
  )



  # message regle diff

  observeEvent(input$regles_diff, {
    showModal_dsfr(
      ui = modalDialog_dsfr(
        tagList(
          p("Les données Filocom sont secrétisées conformément aux règles relatives aux données fiscales. Leur mise en œuvre sont détaillées dans la documentation des cubes."),
          p("Ces données Filocom peuvent être diffusées aux collectivités sans avoir à établir un acte d’engagement de confidentialité. Cependant, le demandeur doit être informé qu'il ne peut pas rediffuser ces tableaux de données et que l'utilisation des données doit faire mention de la source : FILOCOM - SDES.")
        ),
        title = "Règles de diffusion",
        footer = ""
      )
    )
  })
  
  
  # -------------ZE et UU -----------------------------------------------------

  # nommage du résultat du choix du millesime page ZE et UU
  millesime2 <- reactive({
    mill2 <- as.numeric(input$mill2)
  })
    
  # fonction de préparation ZE
  creer_cube_10 <- function (x){
    cube <- x %>%
      filter (TypeZone == "ZE", annee == millesime2())
  }

  #telechargement tous les cubes Zone d'emplois
  output$download_cubes10 <-   downloadHandler(
    file <- function() {
      paste0("Xcubes-ZE-",millesime2(),".zip") #nommage du fichier zip
    },
    content = function(file) {
      #aller dans un repertoire temporaire
      owd <- setwd(tempdir())
      on.exit(setwd(owd))
      files <- NULL; #initialisation de la variable dans laquelle sera stockee les noms des fichiers

      for (i in num_fichiers){
        # ecrire chaque cube dans un csv, sauver le nom
        fileName <- paste("cube ",millesime2(),"-", i,"-ze",".csv",sep = "")
        cube_i <-df_liste[[i]] %>% as.data.frame() %>%
          rename_with(~gsub(i,"",.x)) %>%
          rename_with(~gsub("X.","",.x))
        cubei <- creer_cube_10(cube_i)
        write.table(cubei,fileName,row.names=FALSE,quote=FALSE, sep = ";",fileEncoding = "UTF-8")
        files <- c(fileName,files) #ajout le nom du csv aux précedents
      }
      #creation du fichier zip
      zip(file,files)
    }
  )

  # fonction de préparation UU
  creer_cube_20 <- function (x){
    cube <- x %>%
      filter (TypeZone == "UU", annee == millesime2())
  }

  #telechargement tous les cubes UU
  output$download_cubes20 <-   downloadHandler(
    file <- function() {
      paste0("Xcubes-UU-",millesime2(),".zip") #nommage du fichier zip
    },
    content = function(file) {
      #aller dans un repertoire temporaire
      owd <- setwd(tempdir())
      on.exit(setwd(owd))
      files <- NULL; #initialisation de la variable dans laquelle sera stockee les noms des fichiers

      for (i in num_fichiers){
        # ecrire chaque cube dans un csv, sauver le nom
        # fileName <- paste(i,".csv",sep = "")
        fileName <- paste("cube ",millesime2(),"-", i,"-uu",".csv",sep = "")
        cube_i <-df_liste[[i]] %>% as.data.frame() %>%
          rename_with(~gsub(i,"",.x)) %>%
          rename_with(~gsub("X.","",.x))
        cubei <- creer_cube_20(cube_i)
        write.table(cubei,fileName,row.names=FALSE,quote=FALSE, sep = ";",fileEncoding = "UTF-8")
        files <- c(fileName,files) #ajout le nom du csv aux précedents
      }
      zip(file,files)
    }
  )
  
  # -------------fin ZE et UU -----------------------------------------------------
  
  
})
