% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_nitrate_prelevement_table.R
\name{create_nitrate_analyse_table}
\alias{create_nitrate_analyse_table}
\title{Créer une table d'analyses de nitrates}
\usage{
create_nitrate_analyse_table(version, last_year, connexion)
}
\arguments{
\item{version}{String. Version de la table (par exemple, 'v1').}

\item{last_year}{Integer. L'année la plus récente incluse dans les données de la table.}

\item{connexion}{DBIConnection. Connexion active à la base de données PostgreSQL.}
}
\value{
String. Le script SQL utilisé pour créer la table.
}
\description{
Cette fonction crée une table dans une base de données PostgreSQL
pour stocker les informations relatives aux analyses de nitrates, incluant
les contraintes et les séquences nécessaires.
}
\examples{
# Connexion à la base de données
connexion <- datalibaba::connect_to_db(db = "si_eau", user = "admin")

# Création du script SQL avec la version choisie
version <- "v0_16"
last_year <- "2023"
sql <- create_nitrate_analyse_table(version, last_year, connexion)
}
