# WARNING - Generated by {fusen} from dev/flat_create_tables_sequences.Rmd: do not edit by hand

#' Ajouter une variable code_prelevement au dataframe
#'
#' @description Cette fonction ajoute une nouvelle variable `code_prelevement` 
#' au dataframe en utilisant une séquence PostgreSQL dynamique. La séquence est 
#' construite en fonction du paramètre `version` fourni.
#'
#' @param dataframe Un dataframe contenant les données sur lesquelles ajouter 
#' la variable `code_prelevement`.
#' @param version Une chaîne de caractères représentant la version de la 
#' séquence à utiliser.
#'
#' @return Un dataframe avec une nouvelle colonne `code_prelevement` contenant 
#' les valeurs de la séquence PostgreSQL.
#' 
#' @importFrom DBI dbGetQuery dbDisconnect
#' @importFrom dplyr mutate
#' @importFrom glue glue
#' @importFrom datalibaba connect_to_db
#' @export
add_code_prelevement <- function(dataframe, version) {
  # Établir une connexion à la base de données PostgreSQL
  connexion <- datalibaba::connect_to_db(db = "si_eau", user = "admin")
  
  # Construire le nom de la séquence
  sequence_name <- glue::glue("nitrates.nitrate_prelevement_{version}_code_prelevement_seq")
  
  # Initialiser une liste pour stocker les valeurs de la séquence
  code_prelevements <- c()
  
  # Pour chaque ligne du dataframe, obtenir une valeur de la séquence
  for (i in 1:nrow(dataframe)) {
    query <- glue::glue("SELECT nextval(\'{sequence_name}\') AS code_prelevement")
    result <- DBI::dbGetQuery(connexion, query)
    code_prelevements <- c(code_prelevements, result$code_prelevement)
  }
  
  # Ajouter la nouvelle variable au dataframe
  dataframe <- dataframe |>
    dplyr::mutate(code_prelevement = code_prelevements)
  
  # Fermer la connexion à la base de données
  DBI::dbDisconnect(connexion)
  
  return(dataframe)
}

