# WARNING - Generated by {fusen} from dev/flat_create_tables.Rmd: do not edit by hand

#' Créer une table d'analyses de nitrates
#'
#' @description Cette fonction crée une table dans une base de données PostgreSQL 
#' pour stocker les informations relatives aux analyses de nitrates, incluant 
#' les contraintes et les séquences nécessaires.
#'
#' @param version String. Version de la table (par exemple, 'v1').
#' @param last_year Integer. L'année la plus récente incluse dans les données de la table.
#' @param connexion DBIConnection. Connexion active à la base de données PostgreSQL.
#'
#' @return String. Le script SQL utilisé pour créer la table.
#' @export
#' @importFrom datalibaba connect_to_db
#' @examples
#' # Connexion à la base de données
#' connexion <- datalibaba::connect_to_db(db = "si_eau", user = "admin")
#'
#' # Création du script SQL avec la version choisie
#' version <- "v0_16"
#' last_year <- "2023"
#' sql <- create_nitrate_analyse_table(version, last_year, connexion)
create_nitrate_analyse_table <- function(version, last_year, connexion) {

  # Génération de la date du jour
  date_now <- format(Sys.Date(), "%d/%m/%Y")

  # Création du script avec l'ajout des paramètres
  sql_script <- glue::glue("
    CREATE TABLE IF NOT EXISTS nitrates.nitrate_analyse_{version}
    (
      code_analyse serial NOT NULL,
      code_intervenant character varying(20),
      code_prelevement integer,
      code_parametre bigint,
      code_fraction_analysee integer,
      date_analyse date,
      resultat_analyse double precision,
      code_remarque integer,
      limite_detection double precision,
      limite_quantification double precision,
      CONSTRAINT pk_nitrate_analyse_{version} PRIMARY KEY (code_analyse),
      CONSTRAINT fk_n_fraction_analysee FOREIGN KEY (code_fraction_analysee)
          REFERENCES sandre.n_fraction_analysee (code_fraction_analysee) MATCH SIMPLE
          ON UPDATE CASCADE ON DELETE SET DEFAULT,
      -- CONSTRAINT fk_n_intervenant FOREIGN KEY (code_intervenant)
         -- REFERENCES qualite_cours_d_eau.n_intervenant (code_intervenant) MATCH SIMPLE
         -- ON UPDATE CASCADE ON DELETE SET DEFAULT,
      CONSTRAINT fk_n_remarque FOREIGN KEY (code_remarque)
          REFERENCES sandre.n_remarque (code_remarque) MATCH SIMPLE
          ON UPDATE NO ACTION ON DELETE NO ACTION,
      CONSTRAINT fk_parametre FOREIGN KEY (code_parametre)
          REFERENCES qualite_cours_d_eau.parametre (code_parametre) MATCH SIMPLE
          ON UPDATE CASCADE ON DELETE SET DEFAULT
    )
    WITH (
      OIDS=FALSE
    );

    ALTER TABLE nitrates.nitrate_analyse_{version}
      OWNER TO adminpsql;

    GRANT ALL ON TABLE nitrates.nitrate_analyse_{version} TO adminpsql;
    GRANT ALL ON TABLE nitrates.nitrate_analyse_{version} TO writer_production;
    GRANT SELECT ON TABLE nitrates.nitrate_analyse_{version} TO reader_production;

    COMMENT ON TABLE nitrates.nitrate_analyse_{version}
      IS 'Table des analyses 2007-{last_year} (version {version} du {date_now})';
    COMMENT ON COLUMN nitrates.nitrate_analyse_{version}.code_analyse IS 'Identifiant de l''analyse';
    COMMENT ON COLUMN nitrates.nitrate_analyse_{version}.code_intervenant IS 'Identifiant du laboratoire ayant effectu\u00e9 l''analyse';
    COMMENT ON COLUMN nitrates.nitrate_analyse_{version}.code_prelevement IS 'Identifiant du pr\u00e9l\u00e8vement';
    COMMENT ON COLUMN nitrates.nitrate_analyse_{version}.code_parametre IS 'Identifiant du param\u00e8tre analys\u00e9';
    COMMENT ON COLUMN nitrates.nitrate_analyse_{version}.code_fraction_analysee IS 'Identifiant de la fraction analys\u00e9e';
    COMMENT ON COLUMN nitrates.nitrate_analyse_{version}.date_analyse IS 'Date de l''analyse';
    COMMENT ON COLUMN nitrates.nitrate_analyse_{version}.resultat_analyse IS 'R\u00e9sultat de l''analyse';
    COMMENT ON COLUMN nitrates.nitrate_analyse_{version}.code_remarque IS 'Code validant la donn\u00e9e';
    COMMENT ON COLUMN nitrates.nitrate_analyse_{version}.limite_detection IS 'Limite de d\u00e9tection';
    COMMENT ON COLUMN nitrates.nitrate_analyse_{version}.limite_quantification IS 'Limite de quantification';

    CREATE SEQUENCE IF NOT EXISTS nitrates.nitrate_analyse_{version}_code_analyse_seq
        INCREMENT 1
        START 1
        MINVALUE 1
        MAXVALUE 2147483647
        CACHE 1;

    ALTER SEQUENCE nitrates.nitrate_analyse_{version}_code_analyse_seq
        OWNER TO adminpsql;
  ")

  # Exécution du script dans la base de données
  DBI::dbExecute(connexion, sql_script)

  # Fermeture de la connexion à la base de données
  DBI::dbDisconnect(connexion)

  return(sql_script)
}


#' Créer une table de prélèvements de nitrates
#'
#' @description Cette fonction crée une table dans une base de données PostgreSQL 
#' pour stocker les informations relatives aux prélèvements de nitrates, 
#' incluant les contraintes et les séquences nécessaires.
#'
#' @param version String. Version de la table (par exemple, 'v1').
#' @param last_year Integer. L'année la plus récente incluse dans les données de la table.
#' @param connexion DBIConnection. Connexion active à la base de données PostgreSQL.
#'
#' @return String. Le script SQL utilisé pour créer la table.
#' @export
#' @importFrom datalibaba connect_to_db
#' @examples
#' # Connexion à la base de données
#' connexion <- datalibaba::connect_to_db(db = "si_eau", user = "admin")
#'
#' # Création du script SQL avec la version choisie
#' version <- "v0_16"
#' last_year <- "2023"
#' sql <- create_nitrate_prelevement_table(version, last_year, connexion)
create_nitrate_prelevement_table  <- function(version, last_year, connexion) {
  
  # Génération de la date du jour
  date_now <- format(Sys.Date(), "%d/%m/%Y")
  
  # Création du script avec l'ajout des paramètres
  sql_script <- glue::glue("
    CREATE TABLE IF NOT EXISTS nitrates.nitrate_prelevement_{version}
    (
      code_prelevement serial NOT NULL,
      code_intervenant character varying(20),
      source character varying(10),
      code_reseau character varying(254),
      code_station character varying(10),
      date_prelevement date,
      heure_prelevement character varying(8),
      code_support int,
      nature_eau character varying(3),
      id_usage character varying(3),
      id_prelevement_motif character varying(2),
      commentaire character varying(254),
      CONSTRAINT pk_nitrate_prelevement_{version} PRIMARY KEY (code_prelevement),
      CONSTRAINT fk_n_support FOREIGN KEY (code_support)
          REFERENCES sandre.n_support (code_support) MATCH SIMPLE
          ON UPDATE CASCADE ON DELETE SET DEFAULT
    )
    WITH (
      OIDS=FALSE
    );

    ALTER TABLE nitrates.nitrate_prelevement_{version}
      OWNER TO adminpsql;

    GRANT ALL ON TABLE nitrates.nitrate_prelevement_{version} TO adminpsql;
    GRANT ALL ON TABLE nitrates.nitrate_prelevement_{version} TO writer_production;
    GRANT SELECT ON TABLE nitrates.nitrate_prelevement_{version} TO reader_production;

    COMMENT ON TABLE nitrates.nitrate_prelevement_{version}
      IS 'Table des pr\u00e9l\u00e8vements 2007-{last_year} (version {version} du {date_now})';
    COMMENT ON COLUMN nitrates.nitrate_prelevement_{version}.code_prelevement IS 'Identifiant du pr\u00e9l\u00e8vement';
    COMMENT ON COLUMN nitrates.nitrate_prelevement_{version}.code_intervenant IS 'Identifiant de l''intervenant';
    COMMENT ON COLUMN nitrates.nitrate_prelevement_{version}.source IS 'Source de la donn\u00e9e';
    COMMENT ON COLUMN nitrates.nitrate_prelevement_{version}.code_reseau IS 'Identifiant du r\u00e9seau';
    COMMENT ON COLUMN nitrates.nitrate_prelevement_{version}.code_station IS 'Identifiant de la station';
    COMMENT ON COLUMN nitrates.nitrate_prelevement_{version}.date_prelevement IS 'Date du pr\u00e9l\u00e8vement';
    COMMENT ON COLUMN nitrates.nitrate_prelevement_{version}.heure_prelevement IS 'Heure du pr\u00e9l\u00e8vement';
    COMMENT ON COLUMN nitrates.nitrate_prelevement_{version}.code_support IS 'Code du support de pr\u00e9l\u00e8vement';
    COMMENT ON COLUMN nitrates.nitrate_prelevement_{version}.nature_eau IS 'Nature de l''eau du pr\u00e9l\u00e8vement (ESO/ESU)';
    COMMENT ON COLUMN nitrates.nitrate_prelevement_{version}.id_usage IS 'Code de l''usage du pr\u00e9l\u00e8vement';
    COMMENT ON COLUMN nitrates.nitrate_prelevement_{version}.id_prelevement_motif IS 'Code du motif du pr\u00e9l\u00e8vement';
    COMMENT ON COLUMN nitrates.nitrate_prelevement_{version}.commentaire IS 'Commentaire';

    CREATE SEQUENCE IF NOT EXISTS nitrates.nitrate_prelevement_{version}_code_prelevement_seq
        INCREMENT 1
        START 1
        MINVALUE 1
        MAXVALUE 2147483647
        CACHE 1;

    ALTER SEQUENCE nitrates.nitrate_prelevement_{version}_code_prelevement_seq
        OWNER TO adminpsql;
  ")
  
  # Exécution du script dans la base de données
  DBI::dbExecute(connexion, sql_script)
  
  # Fermeture de la connexion à la base de données
  DBI::dbDisconnect(connexion)
  
  return(sql_script)
}
