# WARNING - Generated by {fusen} from dev/flat_create_tables_sequences.Rmd: do not edit by hand # nolint: line_length_linter.

#' Ajouter une variable code_analyse au dataframe
#'
#' @description Cette fonction ajoute une nouvelle variable `code_analyse` 
#' au dataframe en utilisant une séquence PostgreSQL dynamique. La séquence est 
#' construite en fonction du paramètre `version` fourni.
#'
#' @param dataframe Un dataframe contenant les données sur lesquelles ajouter 
#' la variable `code_analyse`.
#' @param version Une chaîne de caractères représentant la version de la 
#' séquence à utiliser.
#'
#' @return Un dataframe avec une nouvelle colonne `code_analyse` contenant 
#' les valeurs de la séquence PostgreSQL.
#' 
#' @importFrom DBI dbGetQuery dbDisconnect
#' @importFrom dplyr mutate
#' @importFrom glue glue
#' @importFrom datalibaba connect_to_db
#' @export
#' @examples
#' # Crée un dataframe fictif avec les colonnes nécessaires pour l'exemple
#' dataframe <- data.frame(
#'   id_prelevement = 1:5,
#'   autre_colonne = sample(letters, 5)
#' )
#' # Définir une version pour l'exemple
#' version <- "v1"
#'
#' # Utiliser la fonction add_code_analyse() avec la version souhaitée
#' dataframe <- add_code_analyse(
#'   dataframe, version)
#'
add_code_analyse <- function(dataframe, version) {
  # Établir une connexion à la base de données PostgreSQL
  connexion <- datalibaba::connect_to_db(db = "si_eau", user = "admin")
  
  # Créer la séquence correspondant à la table
  create_sequence <- glue::glue("CREATE SEQUENCE IF NOT EXISTS nitrates.nitrate_analyse_{version}_code_analyse_seq
      INCREMENT 1 START 1 MINVALUE 1 MAXVALUE 2147483647 CACHE 1;")
  
  # Exécuter le script dans la base de données
  DBI::dbExecute(connexion, create_sequence)  
  
  # Construire le nom de la séquence
  sequence_name <- glue::glue("nitrates.nitrate_analyse_{version}_code_analyse_seq")
  
  # Initialiser une liste pour stocker les valeurs de la séquence
  code_analyses <- c()
  
  # Pour chaque ligne du dataframe, obtenir une valeur de la séquence
  for (i in 1:nrow(dataframe)) {
    query <- glue::glue("SELECT nextval(\'{sequence_name}\') AS code_analyse")
    result <- DBI::dbGetQuery(connexion, query)
    code_analyses <- c(code_analyses, result$code_analyse)
  }
  
  # Ajouter la nouvelle variable au dataframe
  dataframe <- dataframe |>
    dplyr::mutate(code_analyse = code_analyses)
  
  # Fermer la connexion à la base de données
  DBI::dbDisconnect(connexion)
  
  return(dataframe)
}

