# WARNING - Generated by {fusen} from dev/flat_functions.Rmd: do not edit by hand

#' Create a Simple Features (sf) Object with Transformed Geometry
#'
#' This function converts a dataframe containing geographical coordinates into a simple features (sf) object,
#' renames specific geometry-related columns, and transforms the coordinate reference system (CRS) to EPSG:2154.
#'
#' @param dataframe A dataframe containing geographical coordinates and geometry-related columns.
#' @return A simple features (sf) object with transformed geometry and renamed columns.
#' @importFrom sf st_as_sf st_transform st_crs
#' @importFrom dplyr rename
#' @importFrom hubeau get_qualite_rivieres_station_pc
#' @export
#' @examples
#' library(hubeau)
#' # Téléchargement du lot de données
#' hubeau_qualite_rivieres_station_pc <- hubeau::get_qualite_rivieres_station_pc(code_region="52")
#' # Création de la géométrie
#' hubeau_sf <- create_hubeau_geom(hubeau_qualite_rivieres_station_pc)
create_hubeau_geom <- function(dataframe) {
  # Convertir le dataframe en objet sf
  hubeau_sf <- sf::st_as_sf(dataframe, 
                            coords = c("geometry.coordinates1", "geometry.coordinates2"), 
                            crs = 4326  # WGS 84
                            )
  
  # Renommer la colonne geometry en the_geom
  hubeau_sf <- hubeau_sf |> dplyr::rename(
    geometry_type = geometry.type,
    geometry_crs_type = geometry.crs.type,
    geometry_crs_properties_name = geometry.crs.properties.name,
    the_geom = geometry)
  
  # Changer le SRID de the_geom à 2154 (EPSG:2154)
  hubeau_sf <- sf::st_transform(hubeau_sf, 2154)
  
  return(hubeau_sf)
}
