# WARNING - Generated by {fusen} from dev/flat_functions.Rmd: do not edit by hand

# Définir une dataframe de test
hubeau_qualite_rivieres_station_pc <- data.frame(
  geometry.coordinates1 = c(2.2945, 2.2955),
  geometry.coordinates2 = c(48.8584, 48.8585),
  geometry.type = c("Point", "Point"),
  geometry.crs.type = c("name", "name"),
  geometry.crs.properties.name = c("urn:ogc:def:crs:OGC:1.3:CRS84", "urn:ogc:def:crs:OGC:1.3:CRS84")
)

test_that("create_hubeau_geom works correctly", {
  # Exécuter la fonction
  hubeau_sf <- create_hubeau_geom(hubeau_qualite_rivieres_station_pc)
  
  # Vérifier que le résultat est un objet sf
  expect_s3_class(hubeau_sf, "sf")
  
  # Vérifier que les colonnes sont correctement renommées
  expect_true("geometry_type" %in% names(hubeau_sf))
  expect_true("geometry_crs_type" %in% names(hubeau_sf))
  expect_true("geometry_crs_properties_name" %in% names(hubeau_sf))
  expect_true("the_geom" %in% names(hubeau_sf))
  
  # Vérifier que le SRID est correctement transformé
  expect_equal(sf::st_crs(hubeau_sf)$epsg, 2154)
  
  # Vérifier que les coordonnées sont transformées (différentes des originales)
  original_coords <- sf::st_as_sf(hubeau_qualite_rivieres_station_pc, 
                                  coords = c("geometry.coordinates1", "geometry.coordinates2"), 
                                  crs = sf::st_crs("urn:ogc:def:crs:OGC:1.3:CRS84"))
  expect_false(all(sf::st_coordinates(original_coords) == sf::st_coordinates(hubeau_sf)))
})
