% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_hubeau_geom.R
\name{create_hubeau_geom}
\alias{create_hubeau_geom}
\title{Create a Simple Features (sf) Object with Transformed Geometry}
\usage{
create_hubeau_geom(dataframe)
}
\arguments{
\item{dataframe}{A dataframe containing geographical coordinates and geometry-related columns.}
}
\value{
A simple features (sf) object with transformed geometry and renamed columns.
}
\description{
This function converts a dataframe containing geographical coordinates into a simple features (sf) object,
renames specific geometry-related columns, and transforms the coordinate reference system (CRS) to EPSG:2154.
}
\examples{
library(hubeau)
# Téléchargement du lot de données
hubeau_qualite_rivieres_station_pc <- hubeau::get_qualite_rivieres_station_pc(code_region="52")
# Création de la géométrie
hubeau_sf <- create_hubeau_geom(hubeau_qualite_rivieres_station_pc)
}
