% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commenter_champs.R
\name{exporter_table_comments}
\alias{exporter_table_comments}
\title{Recuperer les commentaires d'une table et de ses champs sur le SGBD et les exporter dans un fichier csv}
\usage{
exporter_table_comments(
  table = NULL,
  schema = NULL,
  db = "public",
  user = "does",
  server = NULL,
  fichier = "dico_var.csv",
  import = FALSE
)
}
\arguments{
\item{table}{Le nom de la table sur le SGBD dont on veut recuperer la description}

\item{schema}{: Le nom du schema qui contient la table dont on recherche le descriptif.}

\item{db}{: Le nom de la base qui contient la table dont on recherche le descriptif.}

\item{user}{: L'identifiant de l'utilisateur SGBD qui se connecte.}

\item{server}{L'adresse ip du serveur, laisser à NULL pour utiliser le variable d'environnement du .Renviron.}

\item{fichier}{L'adresse et le nom du fichier csv a creer, contenant le dictionnaire d'attributs et le commentaire de la tables a exporter.}

\item{import}{booleen, TRUE si on souhaite egalement charger la table dans l'environnement R (FALSE par defaut).}
}
\value{
les commentaires recherches dans un dataframe de 4 champs (nom_schema, nom_table, commentaire) et autant de lignes que de champs de la table commentes + 1 ligne pour le commentaire de table.
}
\description{
Recuperer les commentaires d'une table et de ses champs sur le SGBD et les exporter dans un fichier csv
}
\examples{
\dontrun{
exporter_table_comments(table = "test_iris", schema = "public", db = "public", user = "does",
                        server = "localhost", fichier = "dico_iris.csv")
}
}
