#' @importFrom fs path_expand path_home_r path
#' @importFrom usethis proj_get
scoped_path_r <- function(scope = c("user", "project"), ..., envvar = NULL) {
  scope <- match.arg(scope)
  if (scope == "user" && !is.null(envvar)) {
    env <- Sys.getenv(envvar, unset = "")
    if (!identical(env, "")) {
      return(fs::path_expand(env))
    }
  }
  root <- switch(scope,
                 user = fs::path_home_r(),
                 project = usethis::proj_get()
  )
  fs::path(root, ...)
}

#' Vérifie si les variables système sont bien activées via .Renviron.
#' @importFrom crayon bold bgCyan
#' @importFrom glue glue
#' @importFrom usethis ui_oops ui_info ui_todo ui_done
#' @export
check_server_renviron <- function() {
  path <- scoped_path_r("user", ".Renviron", envvar = "R_ENVIRON_USER")
  if (!file.exists(path)) {
    usethis::ui_oops(glue::glue("{crayon::bold('.Renviron')} : le fichier {crayon::bgCyan$white(path)} n'existe pas"))
  }
  if (file.exists(path)) {
    usethis::ui_info(glue::glue("v\u00e9rification de la configuration des variables syst\u00e8me \u00e0 l'adresse {crayon::bgCyan$white(path)}."))

    if (Sys.getenv('server')=='') {
      usethis::ui_todo(glue::glue("{crayon::bold('.Renviron')} : la variable {crayon::bold('server')} n'est pas d\u00e9finie."))
    }
    if (Sys.getenv('port')=='') {
      usethis::ui_todo(glue::glue("{crayon::bold('.Renviron')} : la variable {crayon::bold('port')} n'est pas d\u00e9finie."))
    }
    if (Sys.getenv('user_does')=='') {
      usethis::ui_todo(glue::glue("{crayon::bold('.Renviron')} : la variable {crayon::bold('user_does')} n'est pas d\u00e9finie."))
    }
    if (Sys.getenv('pwd_does')=='') {
      usethis::ui_todo(glue::glue("{crayon::bold('.Renviron')} : la variable {crayon::bold('pwd_does')} n'est pas d\u00e9finie."))
    }
    if (Sys.getenv('server')!='') {
      usethis::ui_done(glue::glue("{crayon::bold('.Renviron')} : la variable {crayon::bold('server')}  est d\u00e9finie avec la valeur {crayon::bold(Sys.getenv('server'))}"))
    }
    if (Sys.getenv('port')!='') {
      usethis::ui_done(glue::glue("{crayon::bold('.Renviron')} : la variable {crayon::bold('port')} est d\u00e9finie avec la valeur {crayon::bold(Sys.getenv('port'))}"))
    }
    if (Sys.getenv('user_does')!='') {
      usethis::ui_done(glue::glue("{crayon::bold('.Renviron')} : la variable {crayon::bold('user_does')} est d\u00e9finie avec la valeur {crayon::bold(Sys.getenv('user_does'))}"))
    }
    if (Sys.getenv('pwd_does')!='') {
      usethis::ui_done(glue::glue("{crayon::bold('.Renviron')} : la variable {crayon::bold('pwd_does')} est d\u00e9finie avec la valeur {crayon::bold(Sys.getenv('pwd_does'))}"))
    }
  }
}
