% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_data.R
\name{poster_data}
\alias{poster_data}
\title{Chargement d'un dataset sur le serveur avec rpostgis. Par rapport aux autres fonctions \code{post_data()}, \code{post_data_pg()} ouvre et ferme la connexion au SGBD, gere les dataframes spatiaux et les facteurs, et poste quelques metadonnees en commentaire de la table.}
\source{
{rpostgis} http://mablab.org/rpostgis/
}
\usage{
poster_data(
  data = NULL,
  table = NULL,
  schema = NULL,
  pk = NULL,
  post_row_name = FALSE,
  db = "production",
  overwrite = FALSE,
  droits_schema = TRUE,
  user = "does",
  server = NULL
)
}
\arguments{
\item{data}{Un dataframe a verser sur le serveur de donnees.}

\item{table}{Le nom a donner a la table sur le serveur de donnees (character).}

\item{schema}{Le nom du schema sur le serveur de donnees.}

\item{pk}{Cle primaire a creer : indiquer soit le ou les nom(s) du champ qui doivent etre utilises (character vector), soit 1 pour utiliser la premiere colonne (numeric), laisser à NULL (choix par defaut) pour le creer a partir des numeros de lignes.}

\item{post_row_name}{Boleen indiquant si on souhaite verser le nom des lignes du dataframe, FALSE par defaut.}

\item{db}{La base sur laquelle se connecter.}

\item{overwrite}{boleen : TRUE si on veut ecraser le fichier deja present, FALSE par defaut.}

\item{droits_schema}{boleen : TRUE (valeur par defaut) pour ajouter au niveau de la table versee les droits par defaut du schema.}

\item{user}{Le nom d'utilisateur pour se connecter au SGBD.}

\item{server}{l'adresse ip du serveur, laisser à NULL pour utiliser le variable d'environnement du .Renviron}
}
\value{
NULL, la fonction verse le dataset de l'environnement R sur le serveur de donnees.
}
\description{
Chargement d'un dataset sur le serveur avec rpostgis. Par rapport aux autres fonctions \code{post_data()}, \code{post_data_pg()} ouvre et ferme la connexion au SGBD, gere les dataframes spatiaux et les facteurs, et poste quelques metadonnees en commentaire de la table.
}
\examples{
\dontrun{
poster_data(data = iris, table = "test_iris", schema = "public", db = "public",
            pk = NULL, post_row_name = FALSE, overwrite = TRUE, user = "does")
}
}
