#' Standardisation du nom des champs
#'
#' @param noms_var vecteur de noms (character)
#'
#' @return vecteur de noms standardises
#' @export
#'
#' @examples
#' standard_var_pg(names(iris))
standard_var_pg <- function(noms_var) {
  a_remplacer <- "[+-.,!@$%^&*();/|<>]" # liste des caracteres speciaux a faire disparaitre
  gsub(a_remplacer, "_", tolower(noms_var)) # liste des noms corriges pour insertion dans le SGBD
  }
