% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commenter_champs.R
\name{transferer_table_comments}
\alias{transferer_table_comments}
\title{transferer les commentaires d'une table et de ses champs à une autre table identique sur le SGBD}
\usage{
transferer_table_comments(
  table_sce = NULL,
  schema_sce = NULL,
  db_sce = "public",
  table_dest = table_sce,
  schema_dest = NULL,
  db_dest = "public",
  user = "does",
  server = NULL
)
}
\arguments{
\item{table_sce}{Le nom de la table sur le SGBD dont on veut recuperer la description}

\item{schema_sce}{: Le nom du schema qui contient la table dont on recherche le descriptif.}

\item{db_sce}{: Le nom de la base qui contient la table dont on recherche le descriptif.}

\item{table_dest}{Le nom de la table sur le SGBD que l'on souhaite decrire a partir de table_sce, ces deux tables doivent etre de structure identique}

\item{schema_dest}{: Le nom du schema qui contient la table que l'on souhaite decrire.}

\item{db_dest}{: Le nom de la base qui contient la table que l'on souhaite decrire.}

\item{user}{: L'identifiant de l'utilisateur SGBD qui se connecte.}

\item{server}{L'adresse ip du serveur, laisser à NULL pour utiliser le variable d'environnement du .Renviron.}
}
\description{
transferer les commentaires d'une table et de ses champs à une autre table identique sur le SGBD
}
\examples{
\dontrun{
transferer_table_comments(table_sce = "test_iris", schema_sce = "public", db_sce = "public",
schema_dest = "tiger", db_dest = "public",
user = "does", server = "localhost")
}
}
