% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commenter_champs.R
\name{post_dico_attr}
\alias{post_dico_attr}
\title{Postage de commentaires sur tous ou certains champs d'une table SGBD a partir d'un dataframe dictionnaire d'attributs}
\usage{
post_dico_attr(
  dico = NULL,
  table = NULL,
  schema = NULL,
  db = "public",
  user = "does",
  server = NULL
)
}
\arguments{
\item{dico}{Le dataframe dictionnaire d'attributs, comprend deux champs le 1er pour le nom des variables, le second pour leur explicitation. Le nommage de ces deux champs n'a pas d'importance, leur ordre importe en revanche. Ce dataframe comprend autant de lignes que d'attributs que l'on souhaite documenter.}

\item{table}{Le nom de la table sur le SGBD dont on veut decrire les champs}

\item{schema}{: Le nom du schema qui contient la table a commenter.}

\item{db}{: Le nom de la base qui contient la table a commenter.}

\item{user}{: L'identifiant de l'utilisateur SGBD qui se connecte.}

\item{server}{l'adresse ip du serveur, laisser à NULL pour utiliser le variable d'environnement du .Renviron}
}
\description{
Postage de commentaires sur tous ou certains champs d'une table SGBD a partir d'un dataframe dictionnaire d'attributs
}
\examples{
\dontrun{
dico_iris <- data.frame(VAR = names(iris), VAR_LIB = paste("libell\u00e9 de", names(iris)))
post_dico_attr(dico = dico_iris, table = "test_iris", schema = "public", db = "public",
               user = "does", server = "localhost")
}

}
