#' Lister les schémas sur un connecteur
#'
#' @param con Le connecteur de classe PosgreSQLConnection.
#' @return Un vecteur de caractère avec les schémas présents sur le connecteur con.
#' @export
#' @importFrom DBI dbGetQuery
list_schemas <- function(con) {
  all_schemas <- DBI::dbGetQuery(con, "SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA")
  return(all_schemas$schema_name)
}

