library(shinygouv)
library(shiny)
library(leaflet)
library(DT)
library(shinyjs)

ui <- tagList(
  # Activation de shinyjs
  shinyjs::useShinyjs(),
  navbarPage_dsfr(
  id = "navbar_dsfr",
  title = "Catalogue de données",

  header = header_dsfr(
    intitule = c("PREFET", "DE LA REGION", "PAYS DE LA LOIRE"),
    nom_site_service = "Catalogue de données de la DREAL Pays de la Loire",
  ),

  footer = footer_dsfr(
    intitule = c("PREFET", "DE LA REGION", "PAYS DE LA LOIRE"),
    description = "Une application de la DREAL des Pays de la Loire",
    accessibilite = "non"
  ),
  #useShinyjs(),
  # Onglet Rechercher
  navbarPanel_dsfr(
    id = "rechercher_panel",
    title = "Rechercher",
    fluidPage_dsfr(
      h3("Rechercher un lot de données dans le patrimoine de la DREAL"),
      search_bar(),
      tags$br(),
      DT::dataTableOutput("search_results"),
      uiOutput("search_message"),
      tags$head(
        tags$script(HTML("
        function navigateToExplorer() {
        showTabFromHash('explorer');
        }
                         "))
      )
    )
  ),

  # Onglet Explorer
  navbarPanel_dsfr(
    id = "explorer_panel",
    title = "Explorer",
    fluidPage_dsfr(
      sidebarLayout(
        sidebarPanel(
          h3("Explorer les bases de données du patrimoine de la DREAL"),
          selectInput_dsfr("base", "Choisir la base", choices = choix_bases, selected = NULL), # Sélection de la base
          shinygouv::selectInput_dsfr("schema", "Choisir le schéma", NULL), # Sélection du nom du schéma
          shinygouv::selectInput_dsfr("table", "Choisir la table", NULL), # Sélection du nom de la table
          shinygouv::actionButton_dsfr("visualiserMetadata", "Visualiser les métadonnées")# Bouton de validation pour visualiser les métadonnées
        ),
          mainPanel(
            tags$br(),
            uiOutput("breadcrumb_metadata"),
            uiOutput("title_metadata"), # Titre de l'objet sélectionné
            uiOutput("commentaire_metadata"),
            uiOutput("table_metadata"), #Nb de lignes et taille de la table
            DT::dataTableOutput("metadata_table"),
            #uiOutput("metadata_section"), # Section des métadonnées avec "Dictionnaire d'attributs"
            uiOutput("viz_data"), # Visualisation de la table des donnée
            br(),
            # Sous-onglets pour les données et la carte
            uiOutput("conditional_tabs")
      )
    )
  )
  ),

  # Onglet À propos
  navbarPanel_dsfr(
    id = "a_propos_panel",
    title = "À propos",
    fluidPage_dsfr(
      h3("À propos"),
      shiny::includeMarkdown("www/about.md"),
      div(paste0("Date de mise à jour des métadonnées affichées : ", Sys.Date()))
      )
    ),

  # Onglet Mentions légales
  navbarPanel_dsfr(
    id = "mentions_legales_panel",
    title = "Mentions légales",
    fluidPage_dsfr(
      h3("Mentions légales"),
      shiny::includeMarkdown("www/legal_notice.md")
    )
  )
)
)
