# deploiement vers le sserveur interne de dataviz
library(RCurl)
# Connexion FTP vers le serveur de dataviz
con_ftp_svr_dataviz <- paste0("ftp://", Sys.getenv("svr_dataviz_user"), ":", Sys.getenv("svr_dataviz_mdp"),
                              "@", Sys.getenv("svr_dataviz_ip"), "/catalogueR/")

# creation d'une fonction de transfert FTP vers le serveur à l'aide de ftpUpload de RCurl
## Les adresses des fichiers à transferer parte de la racine du projet RStudio
to_svr_dataviz_ftp <- function(fic = "datamart_catalogue.RData") {
  ftpUpload(what = fic, to = paste0(con_ftp_svr_dataviz, fic))
}

# fichiers à transférer
app_files <- c("datamart_catalogue.RData", "global.R", list.files("R/", full.names = TRUE, recursive = TRUE),list.files("www/", full.names = TRUE, recursive = TRUE),
               "server.R", "ui.R", "catalogue.Rproj")
# Exécution des transferts
lapply(X = app_files, FUN = to_svr_dataviz_ftp)

message("Déploiement manuel complet terminé.")

