# deploiement_automatique.R
library(RCurl)

# Connexion FTP vers le serveur de dataviz
con_ftp_svr_dataviz <- paste0("ftp://", Sys.getenv("svr_dataviz_user"), ":", Sys.getenv("svr_dataviz_mdp"),
                              "@", Sys.getenv("svr_dataviz_ip"), "/catalogueR/")

# Fonction pour le transfert FTP du fichier RData
to_svr_dataviz_ftp <- function(fic = "datamart_catalogue.RData") {
  ftpUpload(what = fic, to = paste0(con_ftp_svr_dataviz, fic))
}

app_files <- c("datamart_catalogue.RData", "global.R", list.files("R/", full.names = TRUE, recursive = TRUE),list.files("www/", full.names = TRUE, recursive = TRUE),
               "server.R", "ui.R", "catalogue.Rproj")

# Exécution du transfert pour les fichiers
deploy_fich <- lapply(X = app_files, FUN = function(fic) {
  if (file.exists(fic)) {
    tryCatch({
      print(paste("Déploiement du fichier :", fic))
      to_svr_dataviz_ftp(fic)
    }, error = function(e) {
      print(paste("Erreur lors du déploiement du fichier :", fic, "Erreur :", e$message))
    })
  } else {
    print(paste("Fichier introuvable :", fic))
  }
})

# Résumé du déploiement
if (all(deploy_fich == "Succès")) {
  message("Déploiement automatique terminé avec succès.")
} else {
  message("Déploiement automatique terminé avec des erreurs.")
}
