create_breadcrumb <- function(base, schema, table) {
  breadcrumb_items <- list(
    if (!is.null(base) && base != "") tags$span(id = "base_text", class = "fr-breadcrumb__item", base),
    if (!is.null(schema) && schema != "Tous") tags$span(id = "schema_text", class = "fr-breadcrumb__item", schema),
    if (!is.null(table) && table != "Toutes") tags$span(id = "table_text", class = "fr-breadcrumb__item", table)
  )

  # Filtrer les éléments NULL (non utilisés)
  breadcrumb_items <- Filter(Negate(is.null), breadcrumb_items)

  # Construire le fil d'Ariane
  tags$nav(
    class = "fr-breadcrumb",
    tags$ol(
      class = "fr-breadcrumb__list",
      lapply(breadcrumb_items, function(item) {
        tags$li(class = "fr-breadcrumb__item", item)
      })
    )
  )
}
