prod_enr <- dataset_odre(x = "prod-region-annuelle-enr")
prod_enr_viz <- prep_prod(dataset = prod_enr$dataset, region = "52")
tb_prod <- table_prod(prod_enr_viz)
tb_biogaz <- table_biogaz(prod_enr_viz)

test_that("prep_prod() works", {
  expect_true(is.data.frame(prod_enr_viz))
})

test_that("viz_prod() works", {
  expect_true(ggplot2::is.ggplot(viz_prod(prod_enr_viz)))
})

test_that("table_prod() works", {
  expect_true(is.data.frame(tb_prod))
})

test_that("table_prod_viz() works", {
  expect_is(table_prod_viz(tb_prod), "flextable")
})


test_that("table_biogaz() works", {
  expect_true(is.data.frame(tb_biogaz))
})

test_that("table_biogaz_viz() works", {
  expect_is(table_biogaz_viz(tb_biogaz), "flextable")
})
