% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_dju.R
\name{prep_dju}
\alias{prep_dju}
\title{prep_dju : preparation de l'indice de rigueur pour integration dans le graphe des consommations}
\usage{
prep_dju(
  url_dju_nat = NULL,
  url_dju_reg = NULL,
  reg = "52",
  an = 2024,
  coeff_dju = 25
)
}
\arguments{
\item{url_dju_nat}{: chaine de caractere, fin de l'url qui pointe vers le fichier excel des DJU France metropolitaine publie par le SDES (ce qu'il y a après "https://www.statistiques.developpement-durable.gouv.fr/media/")}

\item{url_dju_reg}{: chaine de caractere, fin de l'url qui pointe vers le fichier excel des DJU France regionaux publie par le SDES, pour avoir tous l'historique utiliser le fichier des vieilles regions (ce qu'il y a après "https://www.statistiques.developpement-durable.gouv.fr/media/")}

\item{reg}{: le code region au format texte}

\item{an}{: l'annee observee au format numerique}

\item{coeff_dju}{: un coefficient qui permet de ramener l'indice de rigueur (oscillant autour de 1) dans l'echelle des consommations regionales (oscillant entre 2 et 70 TWh selon les region), 25 par exemple pour les Pays de la Loire}
}
\value{
un dataframe presentant l'indice de rigueur pour la France et la region observee, depuis 2013, pret a être incorpore dans le graphes des consommations
}
\description{
prep_dju : preparation de l'indice de rigueur pour integration dans le graphe des consommations
}
\examples{
prep_dju(reg = "52", an = 2024, coeff_dju = 25)
}
