## code to prepare `filiere` dataset goes here
library(dplyr)
library(forcats)

filieres = data.frame(indicateur = c("production_eolienne_renouvelable", "production_solaire_renouvelable" , "production_bioenergies_renouvelable",
                                     "production_hydraulique_renouvelable", "production_gaz_renouvelable", "production_electrique_renouvelable",
                                     "production_totale_renouvelable"),
                      filiere = c("\u00e9olien", "solaire photovolta\u00efque", "bio-\u00e9nergies", "hydro-\u00e9lectricit\u00e9", "injections de biom\u00e9thane",
                                  "electricit\u00e9 renouvelable", "toutes EnR de r\u00e9seaux")) %>% 
  mutate_all(~ as.factor(.x) %>% fct_inorder())

usethis::use_data(filieres, overwrite = TRUE)
