#' viz_prod : Visualisation des productions annuelles renouvelables par filiere, France et region observee
#'
#' @param df le dataframe des productions renouvelable tel que produit par la fonction `prep_prod()`
#'
#' @return le graphe ggplot en barres des productions renouvelables
#' @export
#'
#' @examples
#' \dontrun{
#' viz_prod(prod_enr_viz)
#' }
viz_prod <- function(df) {
  dplyr::filter(df, .data$indicateur != "production_electrique_renouvelable", .data$indicateur != "production_totale_renouvelable") %>% 
    ggplot2::ggplot(ggplot2::aes(x = .data$annee, y = .data$prod_TWh, fill = .data$filiere)) +
    ggplot2::geom_bar(stat = "identity", position = "stack") +
    ggplot2::facet_grid(.data$zone ~ ., scales = "free") + 
    gouvdown::scale_fill_gouv_discrete(name = NULL, palette = "pal_gouv_qual2") +
    ggplot2::scale_y_continuous(name = "Production en TWh") + 
    ggplot2::labs(title = "Production annuelle renouvelable inject\u00e9e sur les r\u00e9seaux de gaz et d\'\u00e9lectricit\u00e9 en TWh", 
                  caption = "source : RTE, GRTgaz et Ter\u00e9ga\n Couverture France continentale pour le biogaz et France m\u00e9tropolitaine pour l\'\u00e9lectricit\u00e9",
                  x=NULL) +
    ggplot2::guides(fill = ggplot2::guide_legend(direction = 'vertical', nrow = 2, reverse = FALSE))
  
}
