
#' Visualisation de l'evolution des consommations d'energie par type d'energie, France entiere et region, 
#'
#' @param df le df pret pour la visualisation, produit `par finit_conso()`
#' @param coeff_fce_reg un coefficient qui permet de ramener les consommations nationales a l'echelle des consommations regionales, 1/17 par exemple pour les Pays de la Loire
#'
#' @return le graphique ggplot d'evolution des consommations annuelles
#' @export
#' @importFrom dplyr filter pull slice_head
#' @importFrom ggplot2 ggplot aes geom_line scale_color_manual scale_y_continuous sec_axis scale_linetype labs guides guide_legend
#' @importFrom rlang .data 
#' @importFrom scales breaks_pretty 
#'
#' @examples
#' \dontrun{
#' viz_conso(df = obj3)
#' }  
viz_conso <- function(df, coeff_fce_reg = 1/17) {

  nom_reg <- dplyr::filter(df, .data$id_zone == "1reg") %>%
    dplyr::slice_head(n = 1) %>%
    dplyr::pull(.data$zone)

  lim_y <- min(df$valeur_comp, na.rm =TRUE) * 0.85

  ggplot2::ggplot(df, ggplot2::aes(.data$annee, .data$valeur_comp)) +
    ggplot2::geom_line(ggplot2::aes(color = .data$variable, linetype = .data$id_zone), linewidth = 1) +
    ggplot2::scale_color_manual(values = c("grey70", "#E1000F", "#000091"), name = NULL) +
    ggplot2::scale_x_continuous(breaks = scales::breaks_pretty()) +
    ggplot2::scale_y_continuous(name = nom_reg, limits = c(lim_y, NA),
                       sec.axis = ggplot2::sec_axis(~./coeff_fce_reg, name = "France")) +
    ggplot2::scale_linetype(breaks = c("1reg","2FR"),  labels = c(nom_reg, "France")) +
    ggplot2::labs(title = "Consommation annuelle brute en TWh", caption = "source : SDES, RTE, GRTgaz et Ter\u00e9ga\n Couverture France continentale pour le gaz et France m\u00e9tropolitaine pour l\'\u00e9lectricit\u00e9",
         x=NULL) +
    ggplot2::guides(colour = ggplot2::guide_legend(direction = 'vertical', nrow = 3, reverse = TRUE),
           linetype = ggplot2::guide_legend(direction = 'vertical', nrow = 2, title = NULL))
}
