#' finit_conso finition du dataframe des consommations 
#'
#' @param df_conso le df resultant de `prep_conso()`
#' @param df_dju le df resulatnt de `prep_dju()`
#'
#' @return un dataframe des consommations electriques, gaz et des indices de rigueur France et region, depuis 2013, pret a visualiser
#' @importFrom dplyr bind_rows mutate if_else select rename
#' @importFrom rlang .data
#' @export
#'
#' @examples
#' \dontrun{
#' finit_conso(df_conso = conso_1, df_dju = dju)
#' }

finit_conso <- function(df_conso, df_dju) {
  dplyr::bind_rows(df_conso, df_dju) %>% 
    dplyr::mutate(variable = factor(.data$nrj, levels = c("indice de rigueur", "gaz", "\u00e9lectricit\u00e9")),
                  var_detail = dplyr::if_else(.data$variable == "indice de rigueur", as.character(.data$variable), 
                                       paste("consommation de", .data$variable, "en TWh") %>%
                                  gsub("de \u00e9lec", "d\'\u00e9lec", .)) %>% 
             as.factor) %>% 
    dplyr::select(-"region", -"nrj") %>% 
    dplyr::rename(valeur = "conso_TWh", valeur_comp = "conso_comp", zone = "region2", id_zone = "region3")
}
