#' Editer les deux rapports : l'un comprenant les illustrations a fournir a commenter, l'autre avec les indicateurs necessaires a la production du commentaire.
#'
#' @param repo chaine de caracteres indiquant le nom du repertoire vers lequel on souhaite diriger les deux rapports et le template, s'il existe deja, un question alerte l'utilisateur pour eviter que de precedents travaux ne soient ecrases. Par defaut un repertoire 'bes_cae' est cree dans le HOME de l'utilisateur.
#'
#' @return NULL, Ouvre les deux fichiers Rmd a editer
#' @export
#' @importFrom usethis edit_file
#' @importFrom utils askYesNo browseVignettes
#'
#' @examples
#' edit_rapports(repo = "../bes_cae")

edit_rapports <- function(repo = paste0(Sys.getenv("HOME"), "\\bes_cae")){
  
  repo <- normalizePath(repo)
  
  if(file.exists(repo)) {
    message(paste0("Attention : le dossier \'", repo, "\' existe deja\nvos fichiers risquent d\'\u00eatre \u00e9cras\u00e9s."))
    
    if(!utils::askYesNo(msg = "On l\'utilise quand m\u00eame ?", default = TRUE, c("oui", "non", "surement pas"))) {
      stop("Ex\u00e9cution interrompue pour vous permettre de relancer la fonction edit_rapport() avec un nouveau nom de dossier.")
    }
    
  }
  else {
    # Creer le repertoire de travail
    dir.create(repo, recursive = TRUE, showWarnings = FALSE)
  }
  
  fichiers <- c(system.file("rstudio/templates/project/ressources/rapport.Rmd", package = 'bilan.eco.insee', mustWork = TRUE),
                system.file("rstudio/templates/project/ressources/rapport_modele.docx", package = 'bilan.eco.insee', mustWork = TRUE),
                system.file("doc/exploration.Rmd", package = 'bilan.eco.insee', mustWork = FALSE))
  
  file.copy(from = fichiers, to = repo)
}

bilan.eco.insee_skeleton = function(path, ...) {
  edit_rapports(repo = path)
}