#' Telechargement dataset ODRE
#'
#' @param x nom du jeu de donnee
#'
#' @return une liste de deux dataframes correspondant au dataset lu et a son dictionnaire des variables
#' @importFrom dplyr left_join pull
#' @importFrom httr GET content
#' @importFrom jsonlite fromJSON
#' @importFrom readr read_csv2 locale
#' @importFrom tibble enframe
#' @importFrom rlang .data
#' 
#' @export
#'
#' @examples
#' prod_enr <- dataset_odre(x = "prod-region-annuelle-enr")
#' prod_enr
dataset_odre <- function(x = "prod-region-annuelle-enr") {
  baseurl  <- paste0("https://opendata.reseaux-energies.fr/api/dataset/1.0/", x)
  csvurl <- paste0("https://opendata.reseaux-energies.fr/explore/dataset/", x,
                   "/download/?format=csv&timezone=Europe/Berlin&lang=fr&use_labels_for_header=true&csv_separator=%3B")
  
  metadata <- httr::GET(baseurl) %>%
    httr::content("text") %>%
    jsonlite::fromJSON(flatten = TRUE)
  
  if(!is.null(metadata$error)) {stop(paste0("le dataset ", x, " n\'existe pas"))}
  
  attributs <- metadata$fields
  dataset <- readr::read_delim(file = csvurl, locale = readr::locale(decimal_mark = "."), delim = ";") %>% 
    as.data.frame()
  
  names(dataset) %>% tibble::enframe(name = "n_col", value = "label") %>% dplyr::left_join(attributs, by = "label") %>% dplyr::pull(.data$name) -> names(dataset)
  
  return(list(dico_var = attributs, dataset = dataset))
}
